/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.plugins.rest.common.Link;
import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.xml.bind.annotation.XmlAttribute;

public class UserFormEntity
extends UserEntity {
    @XmlAttribute
    private Set<String> applications;
    @XmlAttribute
    private String text;
    @Min(value=0L, message="usermanagement.users.invite.expiry.format.error")
    @Max(value=999L, message="usermanagement.users.invite.expiry.max")
    @XmlAttribute
    private int expiryDays;
    @XmlAttribute
    private boolean sendNotification;
    @XmlAttribute
    private String template;
    private Iterable<ProductId> productIds;

    private UserFormEntity() {
        super(null, null, null, null, null, null, null, null, null, null, null);
    }

    public UserFormEntity(String name, String firstName, String lastName, String displayName, String emailAddress, PasswordEntity password, Boolean active, Link link, String key, Long directoryId, String directoryName) {
        super(name, firstName, lastName, displayName, emailAddress, password, active, link, key, directoryId, directoryName, false);
    }

    public UserFormEntity(String name, String firstName, String lastName, String displayName, String emailAddress, PasswordEntity password, Boolean active, Link link, String key, Long directoryId, String directoryName, Set<String> applications, String text, int expiryDays, boolean sendNotification, String template) {
        super(name, firstName, lastName, displayName, emailAddress, password, active, link, key, directoryId, directoryName, false);
        this.applications = applications;
        this.text = text;
        this.expiryDays = expiryDays;
        this.sendNotification = sendNotification;
        this.template = template;
    }

    public Set<String> getApplications() {
        return this.applications != null ? this.applications : Collections.emptySet();
    }

    public Iterable<ProductId> getProductIds() {
        if (this.productIds == null) {
            this.productIds = ProductId.getProductIds(this.getApplications());
        }
        return this.productIds;
    }

    public String getText() {
        return this.text;
    }

    public int getExpiryDays() {
        return this.expiryDays;
    }

    public boolean getSendNotification() {
        return this.sendNotification;
    }

    public String getTemplate() {
        return this.template;
    }
}

