/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.sal.api.message.I18nResolver;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ProductEntity {
    private final String id;
    private final String name;
    private final String description;
    private final URI iconUrl;

    public ProductEntity(String id, String name, String description, URI iconUrl) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.iconUrl = iconUrl;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getIconUrl() {
        return this.iconUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductEntity that = (ProductEntity)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(that.iconUrl) : that.iconUrl != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        return result;
    }

    public static ProductEntity fromApplicationLink(ReadOnlyApplicationLink applicationLink, I18nResolver i18nResolver) {
        return new ProductEntity(applicationLink.getId().get(), applicationLink.getName(), i18nResolver.getText(applicationLink.getType().getI18nKey()), applicationLink.getType().getIconUrl());
    }
}

