/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.embedded.api.PasswordScore;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class PasswordScoreEntity {
    @JsonProperty
    private String name;
    @JsonProperty
    private Integer ranking;

    public static PasswordScoreEntity from(@Nonnull PasswordScore passwordScore) {
        return new PasswordScoreEntity(passwordScore);
    }

    public PasswordScoreEntity(@Nonnull PasswordScore passwordScore) {
        Preconditions.checkNotNull((Object)passwordScore, (Object)"passwordScore");
        this.name = passwordScore.name();
        this.ranking = (int)passwordScore.getRanking();
    }

    @JsonCreator
    private PasswordScoreEntity() {
    }

    public String getName() {
        return this.name;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Nonnull
    public PasswordScore toEnum() throws IllegalStateException {
        if (StringUtils.isNotBlank(this.name)) {
            try {
                return PasswordScore.valueOf((String)this.name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (this.ranking != null) {
            try {
                return PasswordScore.fromRanking((long)this.ranking.intValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Can't convert to PasswordScore: " + this);
    }
}

