/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.common.Error;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class ErrorEntity {
    private final List<Error> errors;

    @JsonCreator
    private ErrorEntity(@JsonProperty(value="errors") List<Error> errors) {
        this.errors = errors;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static ErrorEntity of(Throwable t) {
        return ErrorEntity.withGenericError(t.getMessage());
    }

    public static ErrorEntity withGenericError(String message) {
        return new ErrorEntity((List<Error>)ImmutableList.of((Object)new Error(message)));
    }

    public static ErrorEntity withGenericError(Iterable<String> messages) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String message : messages) {
            builder.add((Object)new Error(message));
        }
        return new ErrorEntity((List<Error>)builder.build());
    }

    public static ErrorEntity withFieldLevelError(Map<String, String> fieldErrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, String> fieldError : fieldErrors.entrySet()) {
            builder.add((Object)new Error(fieldError.getKey(), fieldError.getValue()));
        }
        return new ErrorEntity((List<Error>)builder.build());
    }

    public static ErrorEntity withErrors(List<Error> errors) {
        return new ErrorEntity(errors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorEntity that = (ErrorEntity)o;
        return !(this.errors != null ? !this.errors.equals(that.errors) : that.errors != null);
    }

    public int hashCode() {
        return this.errors != null ? this.errors.hashCode() : 0;
    }

    public String toString() {
        return "ErrorEntity{errors=" + this.errors + '}';
    }
}

