/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.util;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntityList;
import com.atlassian.crowd.plugin.rest.entity.AttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.AttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.DirectoryMappingEntity;
import com.atlassian.crowd.plugin.rest.entity.DirectoryMappingEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntitySet;
import com.atlassian.crowd.plugin.rest.util.ApplicationLinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class ApplicationEntityTranslator {
    private ApplicationEntityTranslator() {
    }

    public static Application toApplicationWithNoDirectoryMappings(ApplicationEntity applicationEntity) {
        if (applicationEntity == null) {
            return null;
        }
        ApplicationType applicationType = ApplicationEntityTranslator.toApplicationType(applicationEntity.getType());
        HashMap attributes = Maps.newHashMap();
        if (applicationEntity.getAttributes() != null) {
            for (AttributeEntity attributeEntity : applicationEntity.getAttributes()) {
                attributes.put(attributeEntity.getName(), attributeEntity.getValue());
            }
        }
        return ImmutableApplication.builder((String)applicationEntity.getName(), (ApplicationType)applicationType).setDescription(applicationEntity.getDescription()).setActive(ApplicationEntityTranslator.getBoolean(applicationEntity.isActive()).booleanValue()).setPasswordCredential(ApplicationEntityTranslator.toPasswordCredential(applicationEntity.getPassword())).setRemoteAddresses(ApplicationEntityTranslator.toRemoteAddresses(applicationEntity.getRemoteAddresses())).setLowercaseOutput(ApplicationEntityTranslator.getBoolean(applicationEntity.isLowercaseOutput()).booleanValue()).setAliasingEnabled(ApplicationEntityTranslator.getBoolean(applicationEntity.isAliasingEnabled()).booleanValue()).setAttributes((Map)attributes).build();
    }

    public static ApplicationEntity toApplicationEntity(Application application, Link link) {
        return ApplicationEntityTranslator.toApplicationEntity(application, link, PasswordMode.EXCLUDE_PASSWORD);
    }

    public static ApplicationEntity toApplicationEntity(Application application, Link link, PasswordMode passwordMode) {
        PasswordEntity passwordEntity;
        if (application == null) {
            return null;
        }
        URI applicationUri = link.getHref();
        URI passwordUri = ApplicationLinkUriHelper.buildPasswordUri(applicationUri);
        PasswordCredential credential = application.getCredential();
        switch (passwordMode) {
            case INCLUDE_PASSWORD: {
                passwordEntity = credential == null ? null : new PasswordEntity(credential.getCredential(), Link.edit((URI)passwordUri));
                break;
            }
            case EXCLUDE_PASSWORD: {
                passwordEntity = null;
                break;
            }
            default: {
                throw new AssertionError((Object)"Should not reach here");
            }
        }
        ApplicationEntity applicationEntity = new ApplicationEntity(application.getId(), application.getName(), application.getType().name(), application.getDescription(), application.isActive(), passwordEntity, application.isLowerCaseOutput(), application.isAliasingEnabled(), link);
        RemoteAddressEntitySet remoteAddressEntities = ApplicationEntityTranslator.toRemoteAddressEntities(application.getRemoteAddresses(), applicationUri);
        applicationEntity.setRemoteAddresses(remoteAddressEntities);
        AttributeEntityList attributeEntities = ApplicationEntityTranslator.toAttributeEntities(application.getAttributes());
        applicationEntity.setAttributes(attributeEntities);
        DirectoryMappingEntityList directoryMappingEntities = ApplicationEntityTranslator.toDirectoryMappingEntities(application.getDirectoryMappings(), applicationUri);
        applicationEntity.setDirectoryMappings(directoryMappingEntities);
        return applicationEntity;
    }

    public static PasswordCredential toPasswordCredential(PasswordEntity passwordEntity) {
        if (passwordEntity == null) {
            return null;
        }
        return PasswordCredential.unencrypted((String)passwordEntity.getValue());
    }

    public static List<DirectoryMapping> toDirectoryMappings(DirectoryMappingEntityList directoryMappingEntities, Application application, DirectoryManager directoryManager) throws DirectoryNotFoundException {
        if (directoryMappingEntities == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DirectoryMappingEntity directoryMappingEntity : directoryMappingEntities) {
            Directory directory = directoryManager.findDirectoryById(directoryMappingEntity.getDirectoryId().longValue());
            builder.add((Object)ApplicationEntityTranslator.toDirectoryMapping(directoryMappingEntity, application, directory));
        }
        return builder.build();
    }

    public static DirectoryMapping toDirectoryMapping(DirectoryMappingEntity directoryMappingEntity, Application application, Directory directory) {
        if (directoryMappingEntity == null) {
            return null;
        }
        return new DirectoryMapping(application, directory, directoryMappingEntity.isAuthenticateAll().booleanValue(), ApplicationEntityTranslator.toOperationTypes(directoryMappingEntity.getAllowedOperations()));
    }

    public static DirectoryMappingEntityList toDirectoryMappingEntities(List<DirectoryMapping> directoryMappings, URI applicationUri) {
        if (directoryMappings == null) {
            return null;
        }
        URI directoryMappingsUri = ApplicationLinkUriHelper.buildDirectoryMappingsUri(applicationUri);
        ArrayList directoryMappingEntities = Lists.newArrayListWithExpectedSize((int)directoryMappings.size());
        for (DirectoryMapping directoryMapping : directoryMappings) {
            DirectoryMappingEntity directoryMappingEntity = ApplicationEntityTranslator.toDirectoryMappingEntity(directoryMapping, directoryMappingsUri);
            directoryMappingEntities.add(directoryMappingEntity);
        }
        return new DirectoryMappingEntityList(directoryMappingEntities, Link.self((URI)directoryMappingsUri));
    }

    public static DirectoryMappingEntity toDirectoryMappingEntity(DirectoryMapping directoryMapping, URI directoryMappingsUri) {
        if (directoryMapping == null) {
            return null;
        }
        URI directoryMappingUri = ApplicationLinkUriHelper.buildDirectoryMappingUri(directoryMappingsUri, directoryMapping.getDirectory().getId());
        return new DirectoryMappingEntity(directoryMapping.getDirectory().getId(), directoryMapping.isAllowAllToAuthenticate(), ApplicationEntityTranslator.toOperationTypeStrings(directoryMapping.getAllowedOperations()), Link.self((URI)directoryMappingUri));
    }

    public static Set<RemoteAddress> toRemoteAddresses(RemoteAddressEntitySet remoteAddressEntities) {
        if (remoteAddressEntities == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RemoteAddressEntity remoteAddressEntity : remoteAddressEntities) {
            builder.add((Object)ApplicationEntityTranslator.toRemoteAddress(remoteAddressEntity));
        }
        return builder.build();
    }

    public static ApplicationEntityList toApplicationEntities(Collection<Application> applications, URI baseUri) {
        URI applicationsUri = ApplicationLinkUriHelper.buildApplicationsUri(baseUri);
        ArrayList applicationEntities = Lists.newArrayListWithExpectedSize((int)applications.size());
        for (Application application : applications) {
            Link applicationLink = ApplicationLinkUriHelper.buildApplicationLink(baseUri, application.getId());
            applicationEntities.add(ApplicationEntityTranslator.toApplicationEntity(application, applicationLink));
        }
        return new ApplicationEntityList(applicationEntities, Link.self((URI)applicationsUri));
    }

    public static RemoteAddress toRemoteAddress(RemoteAddressEntity remoteAddressEntity) {
        if (remoteAddressEntity == null) {
            return null;
        }
        return new RemoteAddress(remoteAddressEntity.getValue());
    }

    public static RemoteAddressEntitySet toRemoteAddressEntities(Set<RemoteAddress> remoteAddresses, URI baseUri) {
        if (remoteAddresses == null) {
            return null;
        }
        URI remoteAddressesUri = ApplicationLinkUriHelper.buildRemoteAddressesUri(baseUri);
        Link link = Link.self((URI)remoteAddressesUri);
        HashSet remoteAddressEntities = Sets.newHashSetWithExpectedSize((int)remoteAddresses.size());
        for (RemoteAddress remoteAddress : remoteAddresses) {
            remoteAddressEntities.add(ApplicationEntityTranslator.toRemoteAddressEntity(remoteAddress, remoteAddressesUri));
        }
        return new RemoteAddressEntitySet(remoteAddressEntities, link);
    }

    public static RemoteAddressEntity toRemoteAddressEntity(RemoteAddress remoteAddress, URI baseUri) {
        if (remoteAddress == null) {
            return null;
        }
        URI uri = ApplicationLinkUriHelper.buildRemoteAddressUri(baseUri, remoteAddress.getAddress());
        Link link = Link.self((URI)uri);
        return new RemoteAddressEntity(remoteAddress.getAddress(), link);
    }

    public static Set<OperationType> toOperationTypes(Set<String> types) {
        HashSet operationTypes = Sets.newHashSetWithExpectedSize((int)types.size());
        for (String type : types) {
            operationTypes.add(ApplicationEntityTranslator.toOperationType(type));
        }
        return EnumSet.copyOf(operationTypes);
    }

    public static OperationType toOperationType(String type) {
        return OperationType.valueOf((String)type.toUpperCase());
    }

    public static Set<String> toOperationTypeStrings(Set<OperationType> types) {
        ImmutableSet.Builder operationTypesBuilder = ImmutableSet.builder();
        for (OperationType type : types) {
            operationTypesBuilder.add((Object)ApplicationEntityTranslator.toOperationTypeString(type));
        }
        return operationTypesBuilder.build();
    }

    public static String toOperationTypeString(OperationType type) {
        return type.name();
    }

    public static ApplicationType toApplicationType(String type) {
        Validate.notNull(type, "Application type cannot be null", new Object[0]);
        return ApplicationType.valueOf((String)type.toUpperCase());
    }

    public static AttributeEntityList toAttributeEntities(Map<String, String> attributes) {
        if (attributes == null) {
            return null;
        }
        Set<String> keys = attributes.keySet();
        ArrayList<AttributeEntity> attributeList = new ArrayList<AttributeEntity>(keys.size());
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attributeList.add(new AttributeEntity(entry.getKey(), entry.getValue(), null));
        }
        return new AttributeEntityList(attributeList, null);
    }

    public static Boolean getBoolean(Boolean b) {
        return b != null ? b : Boolean.FALSE;
    }

    public static enum PasswordMode {
        EXCLUDE_PASSWORD,
        INCLUDE_PASSWORD;

    }
}

