/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.application;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.manager.application.AliasAlreadyInUseException;
import com.atlassian.crowd.plugin.rest.service.controller.ApplicationController;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

@Path(value="aliases")
@Consumes(value={"text/plain"})
@Produces(value={"text/plain; charset=utf-8"})
@AnonymousAllowed
public class AliasResource {
    private final ApplicationController applicationController;

    public AliasResource(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @GET
    @Path(value="{applicationId}/alias")
    public String getAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username) throws ApplicationNotFoundException {
        return this.applicationController.getAlias(applicationId, username);
    }

    @PUT
    @Path(value="{applicationId}/alias")
    public Response setAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username, String alias) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        this.applicationController.setAlias(applicationId, username, alias);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="{applicationId}/alias")
    public Response deleteAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="user") String username) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        this.applicationController.deleteAlias(applicationId, username);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{applicationId}/username")
    public String getUsernameForAlias(@PathParam(value="applicationId") long applicationId, @QueryParam(value="alias") String alias) throws ApplicationNotFoundException {
        return this.applicationController.getUsernameForAlias(applicationId, alias);
    }

    @GET
    @Produces(value={"application/json", "text/plain; charset=utf-8"})
    public String getAllAliasesForUserAsJson(@QueryParam(value="user") String username) {
        try {
            StringWriter sw = new StringWriter();
            JsonGenerator generator = new JsonFactory().createJsonGenerator((Writer)sw);
            generator.writeStartObject();
            for (Map.Entry<Long, String> e : this.applicationController.getAliasesForUser(username).entrySet()) {
                generator.writeStringField(e.getKey().toString(), e.getValue());
            }
            generator.writeEndObject();
            generator.close();
            return sw.toString();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

