/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.service.controller.UsersController;
import com.atlassian.crowd.plugin.rest.service.resource.AbstractResource;
import com.atlassian.crowd.plugin.rest.util.EntityExpansionUtil;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.net.URI;
import java.util.ConcurrentModificationException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Path(value="user")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@AnonymousAllowed
public class UsersResource
extends AbstractResource {
    private static final String USER_NAME_QUERY_PARAM = "username";
    private static final String USER_NAME_NULL_ERROR_MSG = "username query parameter must be given";
    private static final String EMAIL_QUERY_PARAM = "email";
    private static final String EMAIL_NULL_ERROR_MSG = "email query parameter must be given";
    private static final String KEY_QUERY_PARAM = "key";
    private static final String NO_IDENTIFIER_ERROR_MSG = "key or username query parameter must be given";
    private final UsersController usersController;

    public UsersResource(UsersController usersController) {
        this.usersController = usersController;
    }

    @GET
    public Response getUser(@QueryParam(value="username") String userName, @QueryParam(value="key") String key) throws UserNotFoundException {
        String applicationName = this.getApplicationName();
        UserEntity userEntity = this.getUserEntity(userName, key, applicationName);
        return Response.ok((Object)userEntity).build();
    }

    private Link userLinkTemplate() {
        return LinkUriHelper.buildUserLink(this.uriInfo.getBaseUri(), "");
    }

    private UserEntity getUserEntity(String userName, String key, String applicationName) throws UserNotFoundException {
        if (userName != null) {
            return this.usersController.findUserByName(applicationName, userName, this.userLinkTemplate(), this.expandAttributes());
        }
        if (key != null) {
            return this.usersController.findUserByKey(applicationName, key, this.userLinkTemplate(), this.expandAttributes());
        }
        throw new IllegalArgumentException(NO_IDENTIFIER_ERROR_MSG);
    }

    @POST
    public Response addUser(UserEntity userEntity) throws InvalidUserException, InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.isTrue(userEntity != null);
        Validate.isTrue(userEntity.getName() != null);
        UserEntity createdUserEntity = this.usersController.addUser(applicationName, userEntity, this.userLinkTemplate());
        URI userUri = LinkUriHelper.buildUserUri(this.uriInfo.getBaseUri(), createdUserEntity.getName());
        return Response.created((URI)userUri).entity((Object)createdUserEntity).build();
    }

    @PUT
    public Response updateUser(@QueryParam(value="username") String userName, UserEntity userEntity) throws InvalidUserException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        if (!StringUtils.equalsIgnoreCase(userName, userEntity.getName())) {
            throw new IllegalArgumentException("The names of the resource location <" + this.uriInfo.getPath() + "> and object <" + userEntity.getName() + "> are not equal");
        }
        this.usersController.updateUser(applicationName, userEntity);
        return Response.noContent().build();
    }

    @DELETE
    public Response removeUser(@QueryParam(value="username") String userName) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        this.usersController.removeUser(applicationName, userName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="attribute")
    public Response getUserAttributes(@QueryParam(value="username") String userName) throws UserNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        Link userLink = LinkUriHelper.buildUserLink(this.uriInfo.getBaseUri(), userName);
        UserEntity userEntity = this.usersController.findUserByName(applicationName, userName, userLink, true);
        return Response.ok((Object)userEntity.getAttributes()).build();
    }

    @POST
    @Path(value="attribute")
    public Response storeUserAttributes(@QueryParam(value="username") String userName, MultiValuedAttributeEntityList attributes) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        this.usersController.storeUserAttributes(applicationName, userName, attributes);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="attribute")
    public Response removeUserAttribute(@QueryParam(value="username") String userName, @QueryParam(value="attributename") String attributeName) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        Validate.notNull(attributeName, "attributename query parameter must be given", new Object[0]);
        this.usersController.removeUserAttribute(applicationName, userName, attributeName);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="password")
    public Response updateUserPassword(@QueryParam(value="username") String userName, PasswordEntity password) throws InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        this.usersController.updateUserPassword(applicationName, userName, password.getValue());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="password")
    public Response deleteUserPassword(@QueryParam(value="username") String userName) throws InvalidCredentialException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        this.usersController.clearUserPassword(applicationName, userName);
        return Response.noContent().build();
    }

    @POST
    @Path(value="mail/password")
    public Response requestPasswordReset(@QueryParam(value="username") String userName) throws InvalidEmailAddressException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        try {
            this.usersController.requestPasswordReset(applicationName, userName);
        }
        catch (ApplicationNotFoundException e) {
            throw new ConcurrentModificationException("Application removed while requesting password reset");
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="mail/usernames")
    public Response requestUsernames(@QueryParam(value="email") String email) throws InvalidEmailAddressException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        String applicationName = this.getApplicationName();
        Validate.notNull(email, EMAIL_NULL_ERROR_MSG, new Object[0]);
        try {
            if (this.usersController.requestUsernames(applicationName, email)) {
                return Response.noContent().build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (ApplicationNotFoundException e) {
            throw new ConcurrentModificationException("Application removed while requesting usernames");
        }
    }

    @GET
    @Path(value="group/direct")
    public Response getDirectGroups(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex) throws MembershipNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        if (StringUtils.isEmpty(groupName)) {
            GroupEntityList directGroups = this.usersController.getDirectGroups(applicationName, userName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directGroups).build();
        }
        GroupEntity directGroup = this.usersController.getDirectGroup(applicationName, userName, groupName, this.getBaseUri());
        return Response.ok((Object)directGroup).build();
    }

    @POST
    @Path(value="group/direct")
    public Response addUserToGroup(@QueryParam(value="username") String userName, GroupEntity parentGroup) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException, MembershipAlreadyExistsException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        try {
            this.usersController.addUserToGroup(applicationName, userName, parentGroup.getName());
            return Response.created((URI)LinkUriHelper.buildDirectParentGroupOfUserUri(this.getBaseUri(), userName, parentGroup.getName())).build();
        }
        catch (GroupNotFoundException e) {
            ErrorEntity errorEntity = new ErrorEntity(ErrorEntity.ErrorReason.of((Exception)((Object)e)), e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorEntity).build();
        }
    }

    @DELETE
    @Path(value="group/direct")
    public Response removeUserFromGroup(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName) throws GroupNotFoundException, MembershipNotFoundException, UserNotFoundException, ApplicationPermissionException, OperationFailedException {
        this.usersController.removeUserFromGroup(this.getApplicationName(), userName, groupName);
        return Response.noContent().build();
    }

    @GET
    @Path(value="group/nested")
    public Response getNestedGroups(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName, @DefaultValue(value="1000") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex) throws MembershipNotFoundException {
        String applicationName = this.getApplicationName();
        Validate.notNull(userName, USER_NAME_NULL_ERROR_MSG, new Object[0]);
        if (StringUtils.isEmpty(groupName)) {
            GroupEntityList directGroups = this.usersController.getNestedGroups(applicationName, userName, this.expandGroups(), maxResults, startIndex, this.getBaseUri());
            return Response.ok((Object)directGroups).build();
        }
        GroupEntity directGroup = this.usersController.getNestedGroup(applicationName, userName, groupName, this.getBaseUri());
        return Response.ok((Object)directGroup).build();
    }

    private boolean expandAttributes() {
        return EntityExpansionUtil.shouldExpandField(UserEntity.class, "attributes", this.request);
    }

    private boolean expandGroups() {
        return EntityExpansionUtil.shouldExpandField(GroupEntityList.class, "groups", this.request);
    }
}

