/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.UserEntityUtil;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class UsersController
extends AbstractResourceController {
    private final ForgottenLoginManager forgottenLoginManager;

    public UsersController(ApplicationService applicationService, ApplicationManager applicationManager, ForgottenLoginManager forgottenLoginManager) {
        super(applicationService, applicationManager);
        this.forgottenLoginManager = forgottenLoginManager;
    }

    public UserEntity findUserByName(String applicationName, String name, Link userLink, boolean expandAttributes) throws UserNotFoundException {
        Application application = this.getApplication(applicationName);
        return UserEntityUtil.expandUser(this.applicationService, application, UserEntity.newMinimalUserEntity(name, applicationName, userLink), expandAttributes);
    }

    public UserEntity findUserByKey(String applicationName, String key, Link userLink, boolean expandAttributes) throws UserNotFoundException {
        Application application = this.getApplication(applicationName);
        if (expandAttributes) {
            UserWithAttributes user = this.applicationService.findUserWithAttributesByKey(application, key);
            return UserEntityUtil.translateWithAttributes((User)user, (Attributes)user, userLink);
        }
        User user = this.applicationService.findUserByKey(application, key);
        return UserEntityUtil.translate(user, userLink);
    }

    public UserEntity addUser(String applicationName, UserEntity userEntity, Link userLink) throws ApplicationPermissionException, InvalidUserException, InvalidCredentialException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        UserWithAttributes user = EntityTranslator.fromUserEntity(userEntity);
        if (user instanceof UserTemplateWithAttributes) {
            boolean encryptedPasswordPresent;
            boolean unencryptedPasswordPresent = userEntity.getPassword() != null && userEntity.getPassword().getValue() != null;
            boolean bl = encryptedPasswordPresent = userEntity.getEncryptedPassword() != null && userEntity.getEncryptedPassword().getValue() != null;
            if (!(unencryptedPasswordPresent ^ encryptedPasswordPresent)) {
                throw new IllegalArgumentException("An unencrypted or encrypted password must be provided exclusively.");
            }
            PasswordCredential passwordCredential = unencryptedPasswordPresent ? PasswordCredential.unencrypted((String)userEntity.getPassword().getValue()) : PasswordCredential.encrypted((String)userEntity.getEncryptedPassword().getValue());
            UserWithAttributes createdUser = this.applicationService.addUser(application, (UserTemplateWithAttributes)user, passwordCredential);
            return UserEntityUtil.translateWithAttributes((User)createdUser, (Attributes)createdUser, userLink);
        }
        throw new AssertionError((Object)"Should be a UserTemplateWithAttributes.");
    }

    public String updateUser(String applicationName, UserEntity userEntity) throws ApplicationPermissionException, InvalidUserException, UserNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        UserWithAttributes user = EntityTranslator.fromUserEntity(userEntity);
        if (user instanceof UserTemplate) {
            User updatedUser = this.applicationService.updateUser(application, (UserTemplate)user);
            return updatedUser.getName();
        }
        throw new AssertionError((Object)"Should be a UserTemplate.");
    }

    public void storeUserAttributes(String applicationName, String username, MultiValuedAttributeEntityList attributes) throws ApplicationPermissionException, UserNotFoundException, OperationFailedException {
        Validate.notNull(attributes);
        Application application = this.getApplication(applicationName);
        Map<String, Set<String>> userAttributes = EntityTranslator.toAttributes(attributes);
        this.applicationService.storeUserAttributes(application, username, userAttributes);
    }

    public void removeUserAttribute(String applicationName, String username, String attributeName) throws ApplicationPermissionException, UserNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeUserAttributes(application, username, attributeName);
    }

    public void requestPasswordReset(String applicationName, String username) throws InvalidEmailAddressException, ApplicationPermissionException, ApplicationNotFoundException, UserNotFoundException {
        Application application = this.applicationManager.findByName(applicationName);
        this.forgottenLoginManager.sendResetLink(application, username, ForgottenLoginManager.DEFAULT_TOKEN_EXPIRY_SECONDS);
    }

    public boolean requestUsernames(String applicationName, String email) throws InvalidEmailAddressException, ApplicationNotFoundException {
        Application application = this.applicationManager.findByName(applicationName);
        return this.forgottenLoginManager.sendUsernames(application, email);
    }

    public void removeUser(String applicationName, String username) throws ApplicationPermissionException, UserNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeUser(application, username);
    }

    public void updateUserPassword(String applicationName, String username, String password) throws ApplicationPermissionException, UserNotFoundException, InvalidCredentialException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.updateUserCredential(application, username, PasswordCredential.unencrypted((String)password));
    }

    public void clearUserPassword(String applicationName, String username) throws ApplicationPermissionException, UserNotFoundException, InvalidCredentialException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.updateUserCredential(application, username, PasswordCredential.NONE);
    }

    public GroupEntityList getDirectGroups(String applicationName, String userName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.user(), (String)userName);
            List groups = this.applicationService.searchDirectGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.user(), (String)userName);
        List groupNames = this.applicationService.searchDirectGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public GroupEntity getDirectGroup(String applicationName, String userName, String groupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isUserDirectGroupMember(application, userName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(userName, groupName);
        }
        return GroupEntity.newMinimalGroupEntity(groupName, null, baseUri);
    }

    public void addUserToGroup(String applicationName, String userName, String groupName) throws ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, OperationFailedException, MembershipAlreadyExistsException {
        Application application = this.getApplication(applicationName);
        this.applicationService.addUserToGroup(application, userName, groupName);
    }

    public void removeUserFromGroup(String applicationName, String userName, String groupName) throws ApplicationPermissionException, MembershipNotFoundException, UserNotFoundException, GroupNotFoundException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        this.applicationService.removeUserFromGroup(application, userName, groupName);
    }

    public GroupEntityList getNestedGroups(String applicationName, String userName, boolean expandGroups, int maxResults, int startIndex, URI baseUri) {
        Application application = this.getApplication(applicationName);
        if (expandGroups) {
            MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.user(), (String)userName);
            List groups = this.applicationService.searchNestedGroupRelationships(application, query);
            return EntityTranslator.toGroupEntities(groups, baseUri);
        }
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.user(), (String)userName);
        List groupNames = this.applicationService.searchNestedGroupRelationships(application, query);
        return EntityTranslator.toMinimalGroupEntities(groupNames, baseUri);
    }

    public GroupEntity getNestedGroup(String applicationName, String userName, String groupName, URI baseUri) throws MembershipNotFoundException {
        Application application = this.getApplication(applicationName);
        boolean isMember = this.applicationService.isUserNestedGroupMember(application, userName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(userName, groupName);
        }
        return GroupEntity.newMinimalGroupEntity(groupName, null, baseUri);
    }
}

