/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.manager.application.AliasAlreadyInUseException;
import com.atlassian.crowd.manager.application.AliasManager;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.manager.validation.XForwardedForUtil;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.rest.entity.ApplicationEntityList;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntity;
import com.atlassian.crowd.plugin.rest.entity.RemoteAddressEntitySet;
import com.atlassian.crowd.plugin.rest.util.ApplicationEntityTranslator;
import com.atlassian.crowd.plugin.rest.util.ApplicationLinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.collect.Sets;
import com.sun.jersey.api.NotFoundException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationController.class);
    private final ApplicationManager applicationManager;
    private final DirectoryManager directoryManager;
    private final TrustedProxyManager trustedProxyManager;
    private final AliasManager aliasManager;

    public ApplicationController(ApplicationManager applicationManager, DirectoryManager directoryManager, TrustedProxyManager trustedProxyManager, AliasManager aliasManager) {
        this.applicationManager = applicationManager;
        this.directoryManager = directoryManager;
        this.trustedProxyManager = trustedProxyManager;
        this.aliasManager = aliasManager;
    }

    public ApplicationEntity getApplicationByName(String name, URI baseUri) throws ApplicationNotFoundException {
        Application application = this.applicationManager.findByName(name);
        Link link = ApplicationLinkUriHelper.buildApplicationLink(baseUri, application.getId());
        return ApplicationEntityTranslator.toApplicationEntity(application, link);
    }

    public ApplicationEntity getApplicationById(long id, URI baseUri) throws ApplicationNotFoundException {
        Application application = this.applicationManager.findById(id);
        Link link = ApplicationLinkUriHelper.buildApplicationLink(baseUri, application.getId());
        return ApplicationEntityTranslator.toApplicationEntity(application, link);
    }

    public ApplicationEntityList getAllApplications(URI baseUri) throws ApplicationNotFoundException {
        List applications = this.applicationManager.findAll();
        return ApplicationEntityTranslator.toApplicationEntities(applications, baseUri);
    }

    public Link addApplicationWithRequestAddress(ApplicationEntity applicationEntity, HttpServletRequest request, URI baseUri) throws InvalidCredentialException, DirectoryNotFoundException {
        Set<String> addresses = this.getRequestAddresses(request);
        if (!addresses.isEmpty()) {
            if (applicationEntity.getRemoteAddresses() == null) {
                applicationEntity.setRemoteAddresses(new RemoteAddressEntitySet(Sets.newHashSet(), null));
            }
            for (String address : addresses) {
                applicationEntity.getRemoteAddresses().addRemoteAddress(new RemoteAddressEntity(address, null));
            }
        }
        return this.addApplication(applicationEntity, baseUri);
    }

    public Link addApplication(ApplicationEntity applicationEntity, URI baseUri) throws InvalidCredentialException, DirectoryNotFoundException {
        Application applicationWithNoDirectoryMappings = ApplicationEntityTranslator.toApplicationWithNoDirectoryMappings(applicationEntity);
        Application addedApplication = this.applicationManager.add(applicationWithNoDirectoryMappings);
        if (applicationEntity.getDirectoryMappings() != null && !applicationEntity.getDirectoryMappings().isEmpty()) {
            List<DirectoryMapping> directoryMappings = ApplicationEntityTranslator.toDirectoryMappings(applicationEntity.getDirectoryMappings(), addedApplication, this.directoryManager);
            ImmutableApplication newApplication = ImmutableApplication.builder((Application)addedApplication).setDirectoryMappings(directoryMappings).build();
            try {
                this.applicationManager.update((Application)newApplication);
            }
            catch (ApplicationManagerException e) {
                throw new RuntimeException(e);
            }
            catch (ApplicationNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return ApplicationLinkUriHelper.buildApplicationLink(baseUri, addedApplication.getId());
    }

    public void removeApplication(long applicationId) throws ApplicationManagerException {
        try {
            Application application = this.applicationManager.findById(applicationId);
            this.applicationManager.remove(application);
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
    }

    public void updateApplication(ApplicationEntity applicationEntity) throws ApplicationNotFoundException, ApplicationManagerException, DirectoryNotFoundException {
        Application newApplication;
        Application applicationWithNoDirectoryMappings = ApplicationEntityTranslator.toApplicationWithNoDirectoryMappings(applicationEntity);
        if (applicationEntity.getDirectoryMappings() != null && !applicationEntity.getDirectoryMappings().isEmpty()) {
            List<DirectoryMapping> directoryMappings = ApplicationEntityTranslator.toDirectoryMappings(applicationEntity.getDirectoryMappings(), applicationWithNoDirectoryMappings, this.directoryManager);
            newApplication = ImmutableApplication.builder((Application)applicationWithNoDirectoryMappings).setDirectoryMappings(directoryMappings).build();
        } else {
            newApplication = applicationWithNoDirectoryMappings;
        }
        this.applicationManager.update(newApplication);
    }

    public void addRemoteAddress(long applicationId, RemoteAddressEntity remoteAddressEntity) throws ApplicationNotFoundException {
        Application application = this.applicationManager.findById(applicationId);
        this.applicationManager.addRemoteAddress(application, ApplicationEntityTranslator.toRemoteAddress(remoteAddressEntity));
    }

    public void removeRemoteAddress(long applicationId, String remoteAddress) throws ApplicationNotFoundException {
        Application application = this.applicationManager.findById(applicationId);
        this.applicationManager.removeRemoteAddress(application, new RemoteAddress(remoteAddress));
    }

    public Set<String> getRequestAddresses(HttpServletRequest request) {
        HashSet addresses = Sets.newHashSet();
        addresses.add(request.getRemoteAddr());
        InetAddress clientAddress = XForwardedForUtil.getTrustedAddress((TrustedProxyManager)this.trustedProxyManager, (HttpServletRequest)request);
        addresses.add(clientAddress.getHostAddress());
        try {
            for (InetAddress address : InetAddress.getAllByName(clientAddress.getHostName())) {
                addresses.add(address.getHostAddress());
            }
        }
        catch (UnknownHostException e) {
            LOGGER.warn(e.getMessage());
        }
        return addresses;
    }

    private static boolean isAliasFor(String alias, String username) {
        return StringUtils.isNotBlank(alias) && !alias.equals(username);
    }

    public String getAlias(long applicationId, String username) throws ApplicationNotFoundException, NotFoundException {
        Application application = this.applicationManager.findById(applicationId);
        String alias = this.aliasManager.findAliasByUsername(application, username);
        if (!ApplicationController.isAliasFor(alias, username)) {
            throw new NotFoundException("No alias for user " + username + " in application " + application.getName());
        }
        return alias;
    }

    public void setAlias(long applicationId, String username, String alias) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        this.aliasManager.storeAlias(this.applicationManager.findById(applicationId), username, alias);
    }

    public void deleteAlias(long applicationId, String username) throws ApplicationNotFoundException, AliasAlreadyInUseException {
        this.aliasManager.removeAlias(this.applicationManager.findById(applicationId), username);
    }

    public String getUsernameForAlias(long applicationId, String alias) throws ApplicationNotFoundException {
        return this.aliasManager.findUsernameByAlias(this.applicationManager.findById(applicationId), alias);
    }

    public Map<Long, String> getAliasesForUser(String username) {
        HashMap<Long, String> aliases = new HashMap<Long, String>();
        for (Application application : this.applicationManager.findAll()) {
            String alias = this.aliasManager.findAliasByUsername(application, username);
            if (!ApplicationController.isAliasFor(alias, username)) continue;
            aliases.put(application.getId(), alias);
        }
        return aliases;
    }
}

