/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.crowd.plugin.rest.filter.BasicAuthenticationHelper;
import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedUserUtil;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicUserAuthenticationFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicUserAuthenticationFilter.class);
    private static final String CHALLENGE_MSG = "User failed to authenticate";
    private static final String BASIC_AUTH_REALM = "Crowd REST Application Management Service";
    private final UserManager userManager;

    public BasicUserAuthenticationFilter(UserManager userManager) {
        this.userManager = userManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        BasicAuthenticationHelper.Credentials credentials = BasicAuthenticationHelper.getBasicAuthCredentials(request);
        if (credentials == null) {
            LOGGER.debug("No basic auth credentials found in request, responding with authentication challenge");
            BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
        } else if (BasicUserAuthenticationFilter.isAuthenticated(request, credentials)) {
            LOGGER.debug("User '{}' is already authenticated", (Object)credentials.getName());
            chain.doFilter((ServletRequest)request, servletResponse);
        } else if (this.authenticate(credentials.getName(), credentials.getPassword())) {
            LOGGER.debug("User '{}' authenticated successfully", (Object)credentials.getName());
            AuthenticatedUserUtil.setAuthenticatedUser(request, credentials.getName());
            chain.doFilter((ServletRequest)request, servletResponse);
        } else {
            LOGGER.info("User '{}' failed authentication", (Object)credentials.getName());
            BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
        }
    }

    public void destroy() {
    }

    private static boolean isAuthenticated(HttpServletRequest request, BasicAuthenticationHelper.Credentials credentials) {
        return credentials.getName().equals(AuthenticatedUserUtil.getAuthenticatedUser(request));
    }

    private boolean authenticate(String username, String password) {
        return this.userManager.authenticate(username, password) && this.userManager.isAdmin(username);
    }
}

