/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.productconfig.rest.resource;

import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.PermissionDeniedException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.usermanagement.client.entity.host.HostEntity;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@FeatureGuard(value="um.renaissance")
public class ConfigResource
extends BaseResource {
    private ProductService productService;

    public ConfigResource(ProductService productService) {
        this.productService = productService;
    }

    @PUT
    @Path(value="products")
    public Response setConfiguration(HostEntity entity) throws Exception {
        String authenticatedApplication = AuthenticatedApplicationUtil.getAuthenticatedApplication(this.request);
        if (StringUtils.isEmpty(authenticatedApplication)) {
            throw new PermissionDeniedException();
        }
        if (!authenticatedApplication.equals(entity.getDescription().getHostId())) {
            throw new PermissionDeniedException();
        }
        this.productService.updateHostConfig(entity);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="products")
    public Response deleteConfiguration() throws IOException {
        String authenticatedApplication = AuthenticatedApplicationUtil.getAuthenticatedApplication(this.request);
        if (StringUtils.isNotEmpty(authenticatedApplication)) {
            Option<HostEntity> maybeHost = this.productService.retrieve(authenticatedApplication);
            if (maybeHost.isDefined()) {
                this.productService.deleteHostConfig(authenticatedApplication);
                return ResponseFactory.ok().build();
            }
            return ResponseFactory.noContent().build();
        }
        throw new PermissionDeniedException();
    }
}

