/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.servlet;

import com.atlassian.crowd.plugin.adminchrome.components.AdminSettingsService;
import com.atlassian.crowd.plugin.adminchrome.util.AdminChromeSystemProperties;
import com.atlassian.crowd.plugin.adminchrome.util.ConfigurationTagBuilder;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.util.license.LicenseableApplication;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HordeBootstrapServlet
extends HttpServlet {
    private static final String USERMANAGEMENT_TEMPLATE_KEY = "static";
    private static final String USERMANAGEMENT_SOY_TEMPLATE = "adminchrome.bootstrapStandalone";
    private SoyTemplateRenderer soyTemplateRenderer;
    private I18nHelper i18nHelper;
    private ConfigurationTagBuilder configurationTagBuilder;
    private DarkFeatureManager darkFeatureManager;
    private UserManager userManager;
    private LicensedApplicationSource licensedApplicationSource;
    private AdminSettingsService adminSettingsService;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.soyTemplateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)((SoyTemplateRenderer)config.getServletContext().getAttribute("soyTemplateRenderer")));
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)((I18nHelper)config.getServletContext().getAttribute("i18nHelper")));
        this.configurationTagBuilder = (ConfigurationTagBuilder)Preconditions.checkNotNull((Object)((ConfigurationTagBuilder)config.getServletContext().getAttribute("configurationTagBuilder")));
        this.darkFeatureManager = (DarkFeatureManager)Preconditions.checkNotNull((Object)((DarkFeatureManager)config.getServletContext().getAttribute("darkFeatureManager")));
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)((UserManager)config.getServletContext().getAttribute("userManager")));
        this.licensedApplicationSource = (LicensedApplicationSource)Preconditions.checkNotNull((Object)((LicensedApplicationSource)config.getServletContext().getAttribute("licensedApplicationSource")));
        this.adminSettingsService = (AdminSettingsService)Preconditions.checkNotNull((Object)((AdminSettingsService)config.getServletContext().getAttribute("adminSettingsService")));
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            resp.setContentType("text/html");
            resp.setCharacterEncoding("UTF-8");
            Date renaissanceWarningDate = this.adminSettingsService.getRenaissanceWarningDate();
            Date renaissanceMigrationDate = this.adminSettingsService.getRenaissanceMigrationDate();
            boolean showRenaissanceWarning = renaissanceWarningDate != null && renaissanceWarningDate.getTime() < new Date().getTime();
            Set<LicenseableApplication> apps = this.licensedApplicationSource.licensedApplications();
            StringBuilder sb = new StringBuilder("[ ");
            for (LicenseableApplication app : apps) {
                sb.append("\"").append(app.getApplicationName()).append("\"").append(",");
            }
            sb.setCharAt(sb.length() - 1, ']');
            UserProfile user = this.userManager.getRemoteUser();
            ImmutableMap properties = ImmutableMap.builder().put((Object)"applicationName", (Object)this.i18nHelper.getText("usermanagement.application.user.management")).put((Object)"logoutUrl", (Object)"/logout").put((Object)"contextPath", (Object)AdminChromeSystemProperties.getContextPath()).put((Object)"umServletPath", (Object)AdminChromeSystemProperties.getServletPath()).put((Object)"horde", (Object)true).put((Object)"environment", (Object)System.getProperty("billing.remote.location", "http://billing.app.dev.atlassian.io")).put((Object)"additionalStaticResources", (Object)this.configurationTagBuilder.get()).put((Object)"enabledDarkFeatures", (Object)this.darkFeatureManager.getFeaturesEnabledForAllUsers().getFeatureKeys()).put((Object)"remoteUserFullName", (Object)(user != null ? user.getFullName() : "")).put((Object)"remoteUsername", (Object)(user != null ? user.getUsername() : "")).put((Object)"showRenaissanceWarning", (Object)showRenaissanceWarning).put((Object)"renaissanceMigrationDate", renaissanceMigrationDate != null ? Long.valueOf(renaissanceMigrationDate.getTime()) : "").put((Object)"products", (Object)sb.toString()).build();
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), USERMANAGEMENT_TEMPLATE_KEY, USERMANAGEMENT_SOY_TEMPLATE, (Map)properties);
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
    }
}

