/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.rest.resource;

import com.atlassian.crowd.plugin.adminchrome.components.AdminSettingsService;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="renaissance")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class AdminSettingsServiceResource {
    private static final String DATE_PARAM = "time";
    private AdminSettingsService adminSettingsService;

    public AdminSettingsServiceResource(AdminSettingsService adminSettingsService) {
        this.adminSettingsService = adminSettingsService;
    }

    @GET
    @Path(value="warning")
    public Response getRenaissanceWarningDate() {
        Date warningDate = this.adminSettingsService.getRenaissanceWarningDate();
        if (warningDate == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)warningDate.getTime()).build();
    }

    @POST
    @Path(value="warning")
    public Response setRenaissanceWarningDate(@QueryParam(value="time") long time) {
        if (time < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        this.adminSettingsService.setRenaissanceWarningDate(new Date(time));
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="warning")
    public Response removeRenaissanceWarningDate() {
        this.adminSettingsService.removeRenaissanceWarningDate();
        return Response.ok().build();
    }

    @GET
    @Path(value="migration")
    public Response getRenaissanceMigrationDate() {
        Date migrationDate = this.adminSettingsService.getRenaissanceMigrationDate();
        if (migrationDate == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)migrationDate.getTime()).build();
    }

    @POST
    @Path(value="migration")
    public Response setRenaissanceMigrationDate(@QueryParam(value="time") long time) {
        if (time < 0L) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        this.adminSettingsService.setRenaissanceMigrationDate(new Date(time));
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="migration")
    public Response removeRenaissanceMigrationDate() {
        this.adminSettingsService.removeRenaissanceMigrationDate();
        return Response.ok().build();
    }
}

