/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.components.impl;

import com.atlassian.crowd.plugin.adminchrome.components.ComponentManager;
import com.atlassian.crowd.plugin.adminchrome.components.entity.ComponentEntity;
import com.atlassian.crowd.plugin.adminchrome.data.ComponentDao;
import com.atlassian.crowd.plugin.adminchrome.data.ComponentEntry;
import com.atlassian.crowd.plugin.adminchrome.data.ComponentRetrievalException;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultComponentManager
implements ComponentManager {
    private static final String VERSION_LATEST = "latest";
    private final ComponentDao<ComponentEntry> componentDao;

    public DefaultComponentManager(ComponentDao<ComponentEntry> componentDao) {
        this.componentDao = componentDao;
    }

    @Override
    @Nonnull
    public Set<ComponentEntity> getAllComponents() throws ComponentRetrievalException {
        Collection entities = Collections2.transform(this.componentDao.getAllComponents(), (Function)new Function<ComponentEntry, ComponentEntity>(){

            public ComponentEntity apply(ComponentEntry entry) {
                return DefaultComponentManager.createComponentEntity(entry);
            }
        });
        return ImmutableSet.copyOf((Collection)entities);
    }

    @Override
    @Nullable
    public ComponentEntity getComponent(String componentName) throws ComponentRetrievalException {
        ComponentEntry componentEntry = this.componentDao.getComponent(componentName);
        return componentEntry != null ? DefaultComponentManager.createComponentEntity(componentEntry) : null;
    }

    private static ComponentEntity createComponentEntity(ComponentEntry componentEntry) {
        return new ComponentEntity.Builder().withName(componentEntry.getName()).withVisibility(componentEntry.isVisible()).withLocation(componentEntry.getLocation()).withVersion((String)Objects.firstNonNull((Object)componentEntry.getVersion(), (Object)VERSION_LATEST)).withJsResources(componentEntry.getJsResources()).withCssResources(componentEntry.getCssResources()).build();
    }
}

