/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.components.impl;

import com.atlassian.crowd.plugin.adminchrome.components.AdminSettingsService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Date;

public class AdminSettingsServiceImpl
implements AdminSettingsService {
    private static final String RENAISSANCE_WARNING_DATE_KEY = "um.renaissance.warning.date";
    private static final String RENAISSANCE_MIGRATION_DATE_KEY = "um.renaissance.migration.date";
    private PluginSettings pluginSettings;

    public AdminSettingsServiceImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public Date getRenaissanceWarningDate() {
        Long time;
        try {
            time = Long.parseLong((String)this.pluginSettings.get(RENAISSANCE_WARNING_DATE_KEY));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Date(time);
    }

    @Override
    public void setRenaissanceWarningDate(Date date) {
        this.pluginSettings.put(RENAISSANCE_WARNING_DATE_KEY, (Object)("" + date.getTime()));
    }

    @Override
    public void removeRenaissanceWarningDate() {
        this.pluginSettings.remove(RENAISSANCE_WARNING_DATE_KEY);
    }

    @Override
    public Date getRenaissanceMigrationDate() {
        Long time;
        try {
            time = Long.parseLong((String)this.pluginSettings.get(RENAISSANCE_MIGRATION_DATE_KEY));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Date(time);
    }

    @Override
    public void setRenaissanceMigrationDate(Date date) {
        this.pluginSettings.put(RENAISSANCE_MIGRATION_DATE_KEY, (Object)("" + date.getTime()));
    }

    @Override
    public void removeRenaissanceMigrationDate() {
        this.pluginSettings.remove(RENAISSANCE_MIGRATION_DATE_KEY);
    }
}

