(function () {
    var flag = require('aui/flag');

    AJS.namespace('UserManagement.routes.PasswordRotationDialog', window, /** @lends UserManagement.password.PasswordRotationDialog# */ Class.extend({
        /**
         * @param {object} policyArguments
         */
        show: function(policyArguments) {
            var instance = this;
            AJS.$("#inline-dialog-password-rotation-policy").remove();
            this._dialog = AJS.InlineDialog(
                "#inline-rotation-dialog",
                "password-rotation-policy",
                function(content, trigger, showPopup) {
                    content.html(usermanagement.passwordpolicy.rotationForm(policyArguments));
                    new UserManagement.UMForm('#password-policy-rotation-form', 'POST', {
                        dataFormatter: function (data) {
                            return _.extend(_.clone(data), {
                                passwordRotationCount: +data.passwordRotationCount
                            });
                        } }).on('done', function (data) {
                            policyArguments.minimumPasswordRotation = data.minimumPasswordRotation;

                            AJS.$("#inline-rotation-dialog").text(AJS.I18n.getText('usermanagement.passwordpolicy.rotation.display', data.minimumPasswordRotation));

                            UserManagement.helpers.triggerAnalytics("passwordpolicy.reuse.change", {
                                reuse: data.minimumPasswordRotation
                            });

                            flag({
                                type: "success",
                                close: "auto",
                                body: AJS.I18n.getText('usermanagement.passwordpolicy.rotation.success')
                            });

                            instance._dialog.hide();
                        }).addValidator(UserManagement.controllers.validators.NumberRangeValidator.create('passwordRotationCount', AJS.I18n.getText('usermanagement.passwordpolicy.invalidRotation', 1, 9), 1, 9, '#rotation-number'));
                    showPopup();
                    return false;
                }, {
                    cacheContent: false,
                    hideDelay: null
                }
            )
        },

        getEvents: function() {
            return {
                "change #unlimited-rotations": function () {
                    var rotationCountField = AJS.$("#passwordRotationCount");
                    rotationCountField.prop("disabled", this.checked);
                    if (!UserManagement.controllers.validators.NumberRangeValidator.validateInt(rotationCountField.val(), 1, 9)) {
                        rotationCountField.val('');
                    }
                },
                "change #rotation-number": function () {
                    AJS.$("#passwordRotationCount").prop("disabled", !this.checked);
                }
            }
        }
    }));
})();
