(function($, root) {
    var flag = require('aui/flag');
    root.helpers = root.helpers || {};
    root.helpers.error = {
        ajaxError: function (errorObject) {
            if (errorObject.status === 401) {
                // Redirect to login screen if user is logged out.
                location.replace("/login?dest-url=" + encodeURIComponent(location.pathname + location.search + location.hash));
            }
        },

        displayLicenceExceededErrorInDetail: function (data) {
            var result = {};
            if (data && !$.isEmptyObject(data)) {
                var title = AJS.I18n.getText("usermanagement.apps.license.exceeded.title"),
                    body = "";

                $.each(data, function (key, value) {
                    var productName = $('input[value="' + key + '"]').parent('div').attr('name');
                    if (value.available >= 0) {
                        body += "<li>" + AJS.I18n.getText("usermanagement.apps.license.exceeded.item", productName, value.needed, value.available) + "</li>";
                    } else {
                        body += "<li>" + AJS.I18n.getText("usermanagement.apps.license.exceeded.item.negative.left", productName, value.needed, -1 * value.available) + "</li>";
                    }

                    if (value.available > 0) {
                        result[key] = "USE";
                    }
                });

                flag({
                    type: "error",
                    close: "manual",
                    title: title,
                    body: "<ul>" + body + "</ul><p>" + AJS.I18n.getText("usermanagement.apps.license.exceeded.tip") + "</p>"
                });
            }
            return result;
        }
    };

    $.ajaxSetup({
        error: root.helpers.error.ajaxError
    });
})(AJS.$, window.UserManagement = window.UserManagement || {});