(function($){
    var pageNavigationSelector = '.aui-page-panel-nav';
    var focusedTaskClasses = 'aui-page-focused aui-page-focused-medium';
    var pageContentSelector = '#page-data';

    function makePageFocusedTask() {
        $(document.body).addClass(focusedTaskClasses);
        $(pageContentSelector).prevAll(pageNavigationSelector).hide();
    }

    function restorePageToDefault() {
        $(document.body).removeClass(focusedTaskClasses);
        $(pageContentSelector).prevAll(pageNavigationSelector).show();
    }

    var focusedTaskFilter = function(routeData){
        // Add and delete pages should be focused tasks
        // move to filter if filters ever happen.
        if (routeData.focusedTask) {
            makePageFocusedTask();
        } else {
            restorePageToDefault();
        }
        return routeData;
    };
    Doppelganger.setFilterHandler('FocusedTaskFilter', focusedTaskFilter);
})(AJS.$);