(function ($, root) {

    root.UMModal = function (options) {
        var dialog = new AJS.Dialog($.extend({
            // AJS.Dialog will by default hide itself on ESCAPE, but we want it removed entirely
            keypressListener: function (e) {
                if (e.keyCode === AJS.keyCode.ESCAPE) {
                    dialog.remove();
                }
            }
        }, options));
        dialog.addPanel("", "", "", 1);
        var $panelBody = dialog.getCurrentPanel().body;
        if (options.submitButton) {
            var submitFunction = options.onSubmit || function () { $panelBody.find("form").submit();};
            dialog.addButton(options.submitButton, submitFunction, 'aui-button aui-button-primary');
            //Remove a class that addButton automatically adds.
            var buttons = dialog.getPage(0).button;
            buttons[buttons.length-1].item.removeClass("button-panel-button");
        }

        dialog.addCancel(options.cancelText || AJS.I18n.getText('usermanagement.generic.cancel'), function () {
            dialog.remove();
        });
        options.title && dialog.addHeader(options.title, "");
        $panelBody.html(options.template || "").on('fail', 'form', function () {
            dialog.updateHeight();
        });
        options.footerTemplate && $panelBody.closest(".dialog-components").find(".dialog-button-panel").prepend(options.footerTemplate);
        if (options.submitButton && !$panelBody.find(':submit').length) {
            $panelBody.find('form').append(AJS('button', options.submitButton).addClass('assistive').prop('tabindex', -1));
        }
        dialog.show();
        dialog.updateHeight();
        return dialog;
    };
}(AJS.$, window.UserManagement = window.UserManagement || {}));