/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.extras.api.Product;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum LicenseableApplication {
    CROWD("crowd", Product.CROWD.getNamespace(), "/crowd"),
    JIRA("jira", Product.JIRA.getNamespace(), ""),
    CONFLUENCE("confluence", Product.CONFLUENCE.getNamespace(), "/wiki"),
    BAMBOO("bamboo", Product.BAMBOO.getNamespace(), "/builds");

    public static final Set<LicenseableApplication> NON_CROWD_APPLICATIONS;
    private final String applicationName;
    private final String namespace;
    private final String context;
    public static final Function<LicenseableApplication, String> NAME_FUNCTION;

    private LicenseableApplication(String applicationName, String namespace, String context) {
        this.applicationName = applicationName;
        this.namespace = namespace;
        this.context = context;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNotificationUri(String endpoint) throws IllegalStateException {
        Preconditions.checkNotNull((Object)this.context);
        return this.context + endpoint;
    }

    public static Predicate<LicenseableApplication> nameFilterIgnoreCase(final String applicationName) {
        return new Predicate<LicenseableApplication>(){

            public boolean apply(LicenseableApplication licenseableApplication) {
                return StringUtils.equalsIgnoreCase(applicationName, licenseableApplication.getApplicationName());
            }
        };
    }

    static {
        NON_CROWD_APPLICATIONS = Sets.difference(EnumSet.allOf(LicenseableApplication.class), (Set)ImmutableSet.of((Object)((Object)CROWD)));
        NAME_FUNCTION = new Function<LicenseableApplication, String>(){

            public String apply(LicenseableApplication licenseableApplication) {
                return licenseableApplication.getApplicationName();
            }
        };
    }
}

