/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.util.license.DefaultLicense;
import com.google.common.base.Optional;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseFileParser {
    private static final Logger log = LoggerFactory.getLogger(LicenseFileParser.class);
    private final LicenseDecoder licenseDecoder;

    public LicenseFileParser(LicenseDecoder licenseDecoder) {
        this.licenseDecoder = licenseDecoder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<DefaultLicense> parseLicenseFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Optional<DefaultLicense> optional = this.parseLicenseFile(inputStream);
            return optional;
        }
        catch (IOException e) {
            return Optional.absent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<DefaultLicense> parseLicenseFile(InputStream inputStream) {
        try {
            Properties licenseProperties = this.licenseDecoder.decode(IOUtils.toString(inputStream));
            if (licenseProperties == null) {
                log.error("There were no products in the license file. Licenses are missing. Treating this as a missing license file.");
                Optional optional = Optional.absent();
                return optional;
            }
            Optional optional = Optional.of((Object)new DefaultLicense(licenseProperties));
            return optional;
        }
        catch (LicenseException e) {
            log.error("Failed to parse the encoded license.", (Throwable)e);
            Optional optional = Optional.absent();
            return optional;
        }
        catch (IOException e) {
            log.error("Encountered an IO error when attempting to read the license file.", (Throwable)e);
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }
}

