/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity.host;

import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.ConfigurationEntity;
import com.atlassian.usermanagement.client.entity.GroupAttributesEntity;
import com.atlassian.usermanagement.client.entity.LicenseInformationEntity;
import com.atlassian.usermanagement.client.entity.PermissionEntity;
import com.atlassian.usermanagement.client.entity.host.HostAdminEntity;
import com.atlassian.usermanagement.client.entity.host.HostDescriptionEntity;
import com.atlassian.usermanagement.client.entity.host.HostLicensingEntity;
import com.atlassian.usermanagement.client.entity.host.HostProductEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

public class HostEntity {
    @JsonProperty
    private final HostDescriptionEntity description;
    @JsonProperty
    private final HostAdminEntity administration;
    @JsonProperty
    private final HostLicensingEntity licensing;
    @JsonProperty
    private final List<HostProductEntity> products;

    @JsonCreator
    public HostEntity(@JsonProperty(value="description") HostDescriptionEntity description, @JsonProperty(value="administration") HostAdminEntity administration, @JsonProperty(value="licensing") HostLicensingEntity licensing, @JsonProperty(value="products") List<HostProductEntity> products) {
        this.description = description;
        this.administration = administration;
        this.licensing = licensing;
        this.products = products;
    }

    public HostDescriptionEntity getDescription() {
        return this.description;
    }

    public HostAdminEntity getAdministration() {
        return this.administration;
    }

    public HostLicensingEntity getLicensing() {
        return this.licensing;
    }

    public List<HostProductEntity> getProducts() {
        return this.products;
    }

    @JsonIgnore
    @Nullable
    public HostProductEntity getProduct(String productId) {
        for (HostProductEntity product : this.products) {
            if (!product.getProductKey().equals(productId)) continue;
            return product;
        }
        return null;
    }

    public static HostEntity convert(String id, String name, URI displayURI, URI rpcURI, String permissionsPath, ConfigurationEntity configuration) {
        PermissionEntity users = HostEntity.getDefaultIfNull(configuration.getPermissions().get((Object)AccessLevel.USE));
        PermissionEntity admins = HostEntity.getDefaultIfNull(configuration.getPermissions().get((Object)AccessLevel.ADMIN));
        PermissionEntity sysadmins = HostEntity.getDefaultIfNull(configuration.getPermissions().get((Object)AccessLevel.SYSADMIN));
        LicenseInformationEntity license = configuration.getLicenseInformation();
        HashSet<AccessLevel> canLogin = new HashSet<AccessLevel>(configuration.getCanLogin());
        return new HostEntity(new HostDescriptionEntity(id, name, displayURI, rpcURI), new HostAdminEntity(canLogin, (Map<AccessLevel, PermissionEntity>)ImmutableMap.of((Object)((Object)AccessLevel.ADMIN), (Object)admins, (Object)((Object)AccessLevel.SYSADMIN), (Object)sysadmins)), new HostLicensingEntity(license.getAccessLevelsExcludedFromCount(), license.getGroupsExcludedFromCount(), license.getLicensePrefix()), (List<HostProductEntity>)ImmutableList.of((Object)new HostProductEntity(id, name, true, license.getLimit(), users, permissionsPath)));
    }

    private static PermissionEntity getDefaultIfNull(PermissionEntity entity) {
        if (entity != null) {
            return entity;
        }
        return new PermissionEntity(new HashMap<String, GroupAttributesEntity>(), new ArrayList<String>());
    }

    private static PermissionEntity samplePermissions(String groupName, boolean isDefault) {
        return new PermissionEntity((Map<String, GroupAttributesEntity>)ImmutableMap.of((Object)groupName, (Object)new GroupAttributesEntity(isDefault)), new ArrayList<String>());
    }

    @JsonIgnore
    public Set<String> getProductKeys() {
        HashSet<String> productIds = new HashSet<String>();
        for (HostProductEntity product : this.getProducts()) {
            productIds.add(product.getProductKey());
        }
        return productIds;
    }

    public String toString() {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return "Unable to print entity: " + e.toString();
        }
    }

    public HostProductEntity findPlatformProduct() {
        if (this.getProducts().size() == 1) {
            return this.getProducts().get(0);
        }
        for (HostProductEntity productEntity : this.getProducts()) {
            if (!productEntity.isPlatform()) continue;
            return productEntity;
        }
        throw new RuntimeException("All hosts must contain a platform product");
    }
}

