/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity;

import com.atlassian.usermanagement.client.entity.ValidationMessageEntity;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ValidationResultEntity {
    @JsonProperty
    private final List<ValidationMessageEntity> warnings;
    @JsonProperty
    private final List<ValidationMessageEntity> errors;
    public static final Predicate<ValidationResultEntity> HAS_ERROR_PREDICATE = new Predicate<ValidationResultEntity>(){

        public boolean apply(ValidationResultEntity input) {
            return input.hasErrors();
        }
    };
    public static final Function<ValidationResultEntity, List<ValidationMessageEntity>> GET_ERRORS = new Function<ValidationResultEntity, List<ValidationMessageEntity>>(){

        public List<ValidationMessageEntity> apply(ValidationResultEntity input) {
            return input.errors;
        }
    };

    @JsonCreator
    public ValidationResultEntity(@JsonProperty(value="warnings") List<ValidationMessageEntity> warnings, @JsonProperty(value="errors") List<ValidationMessageEntity> errors) {
        this.warnings = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(warnings)));
        this.errors = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(errors)));
    }

    public List<ValidationMessageEntity> getWarnings() {
        return this.warnings;
    }

    public List<ValidationMessageEntity> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }
}

