/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity;

import com.atlassian.usermanagement.client.entity.UsageHostEntity;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class UsageHostsEntity {
    private final List<UsageHostEntity> hostApplications;

    @JsonCreator
    public UsageHostsEntity(@JsonProperty(value="hostApplications") List<UsageHostEntity> hostApplications) {
        this.hostApplications = ImmutableList.copyOf(hostApplications);
    }

    @JsonIgnore
    public UsageHostsEntity copyWithoutUsernames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (UsageHostEntity host : this.hostApplications) {
            builder.add((Object)host.copyWithoutUsernames());
        }
        return new UsageHostsEntity((List<UsageHostEntity>)builder.build());
    }

    public List<UsageHostEntity> getHostApplications() {
        return this.hostApplications;
    }
}

