/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity;

import com.atlassian.usermanagement.client.entity.UsageProductEntity;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class UsageHostEntity {
    private String hostType;
    private int uniqueUserCount;
    private Set<String> usernames = new HashSet<String>();
    private List<UsageProductEntity> products;

    @JsonCreator
    public UsageHostEntity(@JsonProperty(value="hostType") String hostType, @JsonProperty(value="products") List<UsageProductEntity> products) {
        this.hostType = hostType;
        this.products = products;
        for (UsageProductEntity productUsers : products) {
            if (productUsers.getUsernames() == null) continue;
            this.usernames.addAll(productUsers.getUsernames());
        }
        this.uniqueUserCount = this.usernames.size();
    }

    private UsageHostEntity(String hostType, List<UsageProductEntity> products, int uniqueUserCount) {
        this.hostType = hostType;
        this.products = ImmutableList.copyOf(products);
        this.uniqueUserCount = uniqueUserCount;
    }

    @JsonIgnore
    protected UsageHostEntity copyWithoutUsernames() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (UsageProductEntity product : this.products) {
            builder.add((Object)product.copyWithoutUsernames());
        }
        return new UsageHostEntity(this.hostType, (List<UsageProductEntity>)builder.build(), this.uniqueUserCount);
    }

    public String getHostType() {
        return this.hostType;
    }

    public int getUniqueUserCount() {
        return this.uniqueUserCount;
    }

    public List<UsageProductEntity> getProducts() {
        return this.products;
    }

    @Nullable
    public Set<String> getUsernames() {
        return this.usernames;
    }
}

