/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.entity;

import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.LicenseInformationEntity;
import com.atlassian.usermanagement.client.entity.PermissionEntity;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ConfigurationEntity {
    @JsonProperty
    private final String productId;
    @JsonProperty
    private final String productDisplayName;
    @JsonProperty
    private final Set<AccessLevel> canLogin;
    @JsonProperty
    private final LicenseInformationEntity licenseInformation;
    @JsonProperty
    private final Map<AccessLevel, PermissionEntity> permissions;
    @JsonProperty
    private final String permissionsPath;

    @JsonCreator
    public ConfigurationEntity(@JsonProperty(value="productId") String productId, @JsonProperty(value="productDisplayName") String productDisplayName, @JsonProperty(value="canLogin") Set<AccessLevel> canLogin, @JsonProperty(value="licenseInformation") LicenseInformationEntity licenseInformation, @JsonProperty(value="permissions") Map<AccessLevel, PermissionEntity> permissions, @JsonProperty(value="permissionsPath") String permissionsPath) {
        this.productId = productId;
        this.productDisplayName = productDisplayName;
        this.canLogin = ConfigurationEntity.validateCanLogin(canLogin);
        this.licenseInformation = licenseInformation;
        this.permissions = permissions;
        this.permissionsPath = permissionsPath;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductDisplayName() {
        return this.productDisplayName;
    }

    public Set<AccessLevel> getCanLogin() {
        return this.canLogin;
    }

    public LicenseInformationEntity getLicenseInformation() {
        return this.licenseInformation;
    }

    public Map<AccessLevel, PermissionEntity> getPermissions() {
        return this.permissions;
    }

    public String getPermissionsPath() {
        return this.permissionsPath;
    }

    private static Set<AccessLevel> validateCanLogin(Collection<AccessLevel> includedAccessLevels) {
        ImmutableSet included = ImmutableSet.copyOf((Collection)Collections2.filter((Collection)((Collection)Preconditions.checkNotNull(includedAccessLevels, (Object)"canLogin must not be null.")), (Predicate)Predicates.notNull()));
        Preconditions.checkArgument((!included.isEmpty() ? 1 : 0) != 0, (Object)"canLogin must not be empty.");
        return included;
    }
}

