/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.usermanagement.client.config;

import com.atlassian.usermanagement.client.AccessLevel;

public class CrowdAttributeFormat {
    public static final String PREFIX_SYNC = "synch";
    public static final String PREFIX_UNAPPROVED = "access-unapproved";
    public static final String PREFIX_ACCESS = "access";
    public static final String PREFIX_SEPARATOR = ".";
    public static final String ATT_SEPARATOR = ":";
    public static final String DEFAULT_PREFIX = "DEFAULT_";

    public static String generateAdmin(String hostId) {
        return CrowdAttributeFormat.generatePrefix(hostId) + CrowdAttributeFormat.addSeparator(AccessLevel.ADMIN, false);
    }

    public static String generateUnapprovedAdmin(String hostId) {
        return CrowdAttributeFormat.generateUnapprovedPrefix(hostId) + CrowdAttributeFormat.addSeparator(AccessLevel.ADMIN, false);
    }

    public static String generateSysAdmin(String hostId) {
        return CrowdAttributeFormat.generatePrefix(hostId) + CrowdAttributeFormat.addSeparator(AccessLevel.SYSADMIN, false);
    }

    public static String generateUse(String hostId, String productKey) {
        return CrowdAttributeFormat.generatePrefix(hostId) + CrowdAttributeFormat.escapeWithSeparator(productKey) + CrowdAttributeFormat.addSeparator(AccessLevel.USE, false);
    }

    public static String generateDefaultUse(String hostId, String productKey) {
        return CrowdAttributeFormat.generatePrefix(hostId) + CrowdAttributeFormat.escapeWithSeparator(productKey) + CrowdAttributeFormat.addSeparator(AccessLevel.USE, true);
    }

    public static String generateUnapprovedUse(String hostId, String productKey, boolean isDefault) {
        return CrowdAttributeFormat.generateUnapprovedPrefix(hostId) + CrowdAttributeFormat.escapeWithSeparator(productKey) + CrowdAttributeFormat.addSeparator(AccessLevel.USE, isDefault);
    }

    private static String generatePrefix(String hostId) {
        return "synch." + hostId + PREFIX_SEPARATOR + PREFIX_ACCESS;
    }

    private static String generateUnapprovedPrefix(String hostId) {
        return "synch." + hostId + PREFIX_SEPARATOR + PREFIX_UNAPPROVED;
    }

    private static String addSeparator(AccessLevel level, boolean isDefault) {
        if (isDefault) {
            return ":DEFAULT_" + (Object)((Object)level);
        }
        return ATT_SEPARATOR + (Object)((Object)level);
    }

    private static String escapeWithSeparator(String component) {
        String partial = component.replace("\\", "\\\\");
        partial = partial.replace(ATT_SEPARATOR, "\\:");
        return ATT_SEPARATOR + partial;
    }
}

