/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.util;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;

public class ServiceDeskValidationFunctions {
    public static String SERVICE_DESK_REQUESTOR_KEY = "synch.servicedesk.requestor";

    public static Predicate<String> isServiceDeskRequestor(final DirectoryLocator directoryLocator, final DirectoryManager directoryManager) {
        return new Predicate<String>(){

            public boolean apply(String username) {
                try {
                    BooleanRestriction restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)PropertyUtils.ofTypeString((String)SERVICE_DESK_REQUESTOR_KEY)).isNull(), Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)username)});
                    EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(1);
                    return directoryManager.searchUsers(directoryLocator.getDirectoryId(), query).isEmpty();
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

