/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseCheckFunction;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.MembershipChangeCausingLicenseExceeded;
import com.atlassian.fugue.Option;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;

public class LicenseCheckFunctionAddUsersToGroups
extends LicenseCheckFunction<MembershipChangeCausingLicenseExceeded> {
    private final Set<String> groups;
    private final Set<String> usernames;

    public LicenseCheckFunctionAddUsersToGroups(Set<String> groups, Set<String> usernames, UserProvisioningService userProvisioningService, boolean byPassInactiveUserFilter) {
        super(userProvisioningService, byPassInactiveUserFilter);
        this.groups = groups;
        this.usernames = usernames;
    }

    @Override
    protected Option<MembershipChangeCausingLicenseExceeded> buildError(Product product, Set<String> usersGainingAccess, int seatsRequired, int seatsAvailable) {
        Set<String> loginGroupsToAdd = this.getLoginGroupsToAdd(this.userProvisioningService.getAllLoginGroups(product));
        return Option.some(new MembershipChangeCausingLicenseExceeded(usersGainingAccess, loginGroupsToAdd, new LicenseExceeded(seatsRequired, seatsAvailable)));
    }

    @Override
    protected Set<String> getUsersPotentiallyGainingLicenseSeat(Product product) {
        Set<String> loginGroups = this.userProvisioningService.getAllLoginGroups(product);
        Set<String> loginGroupsToAdd = this.getLoginGroupsToAdd(loginGroups);
        if (loginGroupsToAdd.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.usernames;
    }

    private Set<String> getLoginGroupsToAdd(Set<String> loginGroups) {
        return Sets.intersection(loginGroups, this.groups);
    }
}

