/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.products;

import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.host.HostEntity;
import com.atlassian.usermanagement.client.entity.host.HostProductEntity;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public final class ProductUtils {
    public static final Function<Product, String> PRODUCT_TO_HOST_TYPE = new Function<Product, String>(){

        public String apply(@Nullable Product input) {
            return input.getHostType();
        }
    };

    private ProductUtils() {
        throw new UnsupportedOperationException();
    }

    public static Predicate<HostProductEntity> getLicenseFilter(final HostEntity host, final LicensedApplicationSource licenseSource) {
        return new Predicate<HostProductEntity>(){

            public boolean apply(HostProductEntity product) {
                return licenseSource.isProductLicensed(ProductUtils.getProductLicenseNamespace(host, product));
            }
        };
    }

    public static String getProductLicenseNamespace(HostEntity host, HostProductEntity product) {
        return host.getLicensing().getLicensePrefix() + product.getProductKey();
    }

    public static Set<Product> getAvailableProductsAccessibleViaGroups(List<Product> allProducts, Set<String> groups) {
        HashSet<Product> effectiveProducts = new HashSet<Product>();
        for (Product potentialProduct : allProducts) {
            ProductConfig config;
            Set<String> loginGroups;
            Either<ProductAccessError, ProductConfig> maybeConfig = potentialProduct.fetchProductConfig();
            if (!maybeConfig.isRight() || Sets.intersection(loginGroups = (config = (ProductConfig)maybeConfig.right().get()).getCanLoginGroups(), groups).isEmpty()) continue;
            effectiveProducts.add(potentialProduct);
        }
        return effectiveProducts;
    }

    public static Set<Product> excludeUnnecessaryPlatformProducts(Set<Product> products) {
        HashSet includedPlatformProducts = new HashSet();
        for (Product product : products) {
            ProductId platformId;
            Option<Product> maybeProduct;
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            if (!maybeConfig.isRight()) continue;
            ProductConfig config = (ProductConfig)maybeConfig.right().get();
            if (product.isPlatform() || !(maybeProduct = ProductUtils.findProduct(products, platformId = config.getPlatformProductId())).isDefined()) continue;
            includedPlatformProducts.add(maybeProduct.get());
        }
        return Sets.difference(products, includedPlatformProducts);
    }

    public static Set<Product> findProducts(Iterable<Product> products, final Set<ProductId> productIds) {
        Iterable filtered = com.google.common.collect.Iterables.filter(products, (Predicate)new Predicate<Product>(){

            public boolean apply(@Nullable Product input) {
                return productIds.contains(input.getProductId());
            }
        });
        return ImmutableSet.copyOf((Iterable)filtered);
    }

    public static Option<Product> findProduct(Iterable<Product> products, final ProductId productId) {
        return Iterables.findFirst(products, new Predicate<Product>(){

            public boolean apply(@Nullable Product input) {
                return input.getProductId().equals(productId);
            }
        });
    }

    public static Set<String> getGroupsForLevels(Set<AccessLevel> levels, ProductConfig config) {
        HashSet<String> groups = new HashSet<String>();
        for (AccessLevel level : levels) {
            groups.addAll(config.getGroups(level));
        }
        return ImmutableSet.copyOf(groups);
    }

    public static Set<String> getDefaultGroupsForAvailableProducts(Iterable<Product> products) {
        HashSet<String> allDefaultGroups = new HashSet<String>();
        for (Product product : products) {
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            if (!maybeConfig.isRight()) continue;
            ProductConfig config = (ProductConfig)maybeConfig.right().get();
            allDefaultGroups.addAll(config.getDefaultGroups(AccessLevel.USE));
        }
        return ImmutableSet.copyOf(allDefaultGroups);
    }

    public static void checkAvailableProductsHaveDefaultGroups(Iterable<Product> products) throws NoDefaultGroupException {
        for (Product product : products) {
            Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
            if (!maybeConfig.isRight() || !((ProductConfig)maybeConfig.right().get()).getDefaultGroups(AccessLevel.USE).isEmpty()) continue;
            throw new NoDefaultGroupException(product);
        }
    }
}

