/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.products;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductEntity;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ApplinkProductType;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.fugue.Either;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.entity.ConfigurationEntity;
import com.atlassian.usermanagement.client.entity.GroupAttributesEntity;
import com.atlassian.usermanagement.client.entity.LicenseInformationEntity;
import com.atlassian.usermanagement.client.entity.PermissionEntity;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class ApplinkProduct
implements Product {
    private static final String USER_PROVISIONING_REST_URL_PERMISSION_USER = "/rest/userprovisioning/1/permission/%s/user/%s";
    private ReadOnlyApplicationLink link;
    private ProductId productId;
    private Either<ProductAccessError, ConfigurationEntity> config;

    public ApplinkProduct(@Nonnull ReadOnlyApplicationLinkWithConfig config) {
        this.link = config.getDelegate();
        this.config = config.getConfig();
        this.productId = new ProductId(this.link.getId());
    }

    @VisibleForTesting
    public ApplinkProduct(@Nonnull ReadOnlyApplicationLink link, @Nonnull ConfigurationEntity entity) {
        this.link = link;
        this.config = Either.right(entity);
        this.productId = new ProductId(link.getId());
    }

    @Override
    public String getHostId() {
        return this.link.getId().toString();
    }

    @Override
    public String getHostType() {
        return ApplinkProductType.getHostType(this.link);
    }

    @Override
    public String getProductKey() {
        return ApplinkProductType.getProductKey(this.link);
    }

    @Override
    public ProductEntity getProductEntity(I18nResolver i18nResolver) {
        return new ProductEntity(this.link.getId().get(), this.link.getName(), i18nResolver.getText(this.link.getType().getI18nKey()), this.link.getType().getIconUrl());
    }

    @Override
    public ProductId getProductId() {
        return this.productId;
    }

    @Override
    public String getProductName() {
        Either<ProductAccessError, ProductConfig> config = this.fetchProductConfig();
        if (config.isRight()) {
            return ((ProductConfig)config.right().get()).getConfiguredProductName();
        }
        return this.link.getName();
    }

    @Override
    public Boolean hasProductConfig() {
        return this.config.isRight();
    }

    @Override
    public boolean isPlatform() {
        return true;
    }

    @Override
    public Either<ProductAccessError, ProductConfig> fetchProductConfig() {
        if (this.config.isRight()) {
            return Either.right(new Config((ConfigurationEntity)this.config.right().get()));
        }
        return Either.left(this.config.left().get());
    }

    @Override
    public String getPermissionsUrl() {
        Either<ProductAccessError, ProductConfig> config = this.fetchProductConfig();
        if (config.isRight()) {
            return ((ProductConfig)config.right().get()).getPermissionsUrl();
        }
        return this.link.getDisplayUrl() + ApplinkProductType.getPermissionsPath(this.link);
    }

    @Override
    public void revokeUser(String username, AccessLevel accessLevel) throws CredentialsRequiredException, ResponseException {
        this.link.createAuthenticatedRequestFactory().createRequest(Request.MethodType.DELETE, String.format(USER_PROVISIONING_REST_URL_PERMISSION_USER, accessLevel.name(), username)).execute();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplinkProduct that = (ApplinkProduct)o;
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        return !(this.link != null ? !this.link.equals(that.link) : that.link != null);
    }

    public int hashCode() {
        int result = this.link != null ? this.link.hashCode() : 0;
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        return result;
    }

    private class Config
    implements ProductConfig {
        private ConfigurationEntity entity;

        public Config(ConfigurationEntity entity) {
            this.entity = entity;
        }

        @Override
        public Map<AccessLevel, PermissionEntity> getPermissions() {
            return this.entity.getPermissions();
        }

        @Override
        public String getPermissionsUrl() {
            return ApplinkProduct.this.link.getDisplayUrl() + this.entity.getPermissionsPath();
        }

        @Override
        public PermissionEntity getPermissions(AccessLevel level) {
            return this.entity.getPermissions().get((Object)level);
        }

        @Override
        public Set<AccessLevel> getAccessLevelsExcludedFromCount() {
            return this.entity.getLicenseInformation().getAccessLevelsExcludedFromCount();
        }

        @Override
        public Set<String> getGroupsExcludedFromCount() {
            return this.entity.getLicenseInformation().getGroupsExcludedFromCount();
        }

        @Override
        public LicenseInformationEntity getLicense() {
            return this.entity.getLicenseInformation();
        }

        @Override
        public Set<AccessLevel> getCanLoginLevels() {
            return this.entity.getCanLogin();
        }

        @Override
        public Map<String, GroupAttributesEntity> getGroupPermissions(AccessLevel level) {
            return PermissionEntity.getGroupPermissions(this.getPermissions(), level);
        }

        @Override
        public Set<String> getGroups(AccessLevel level) {
            return PermissionEntity.getGroups(this.getPermissions(), level);
        }

        @Override
        public Set<String> getCanLoginGroups() {
            return ProductUtils.getGroupsForLevels(this.getCanLoginLevels(), this);
        }

        @Override
        public Set<String> getDefaultGroups(AccessLevel level) {
            return PermissionEntity.getDefaultGroups(this.getPermissions(), level);
        }

        @Override
        public Boolean isPlatformProduct() {
            return true;
        }

        @Override
        public String getPlatformProductName() {
            return ApplinkProduct.this.getProductName();
        }

        @Override
        public ProductId getPlatformProductId() {
            return ApplinkProduct.this.productId;
        }

        @Override
        public Boolean isConfigurable() {
            return false;
        }

        @Override
        public String getConfiguredProductName() {
            return this.entity.getProductDisplayName();
        }
    }
}

