/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.common.UriBuilder;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ValidationService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.usermanagement.client.entity.ValidationMessageEntity;
import com.atlassian.usermanagement.client.entity.ValidationResultEntity;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationServiceImpl
implements ValidationService {
    private static final Logger logger = LoggerFactory.getLogger(ValidationServiceImpl.class);
    public static final String BASE_URL = "/rest/userprovisioning/1/validation";
    public static final String USER_URL = "/rest/userprovisioning/1/validation/user/predelete";
    public static final String GROUP_URL = "/rest/userprovisioning/1/validation/group/predelete";
    public static final String GROUPNAME_PARAM = "groupname";
    public static final String USERNAME_PARAM = "username";
    private final ApplicationLinkFilteringService applicationLinkFilteringService;
    private final I18nResolver i18nResolver;

    public ValidationServiceImpl(ApplicationLinkFilteringService applicationLinkFilteringService, I18nResolver i18nResolver) {
        this.applicationLinkFilteringService = applicationLinkFilteringService;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Map<ReadOnlyApplicationLink, ValidationResultEntity> userPreDelete(String username) {
        String url = UriBuilder.fromPath(USER_URL).queryParam(USERNAME_PARAM, username).build().toString();
        return this.runValidation(url);
    }

    @Override
    public Map<ReadOnlyApplicationLink, ValidationResultEntity> groupPreDelete(String groupname) {
        String url = UriBuilder.fromPath(GROUP_URL).queryParam(GROUPNAME_PARAM, groupname).build().toString();
        return this.runValidation(url);
    }

    private Map<ReadOnlyApplicationLink, ValidationResultEntity> runValidation(String url) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (ReadOnlyApplicationLink applicationLink : this.applicationLinkFilteringService.getApplicationLinks()) {
            ValidationResultEntity result = this.preDeleteRequest(applicationLink, url);
            mapBuilder.put((Object)applicationLink, (Object)result);
        }
        return mapBuilder.build();
    }

    private ValidationResultEntity preDeleteRequest(final ReadOnlyApplicationLink applink, String url) {
        try {
            return (ValidationResultEntity)applink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, url).executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, ValidationResultEntity>(){

                public ValidationResultEntity handle(Response response) throws ResponseException {
                    if (response.isSuccessful()) {
                        return (ValidationResultEntity)response.getEntity(ValidationResultEntity.class);
                    }
                    logger.error("Failed to retrieve ValidationResultEntity for {}: {} {}", new Object[]{applink.getName(), response.getStatusCode(), response.getStatusText()});
                    return new ValidationResultEntity(Collections.emptyList(), Collections.singletonList(new ValidationMessageEntity(ValidationServiceImpl.this.i18nResolver.getText("usermanagement.apps.communication.error", new Serializable[]{applink.getName(), response.getStatusText()}))));
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Failed to retrieve ValidationResultEntity for {}: {}", (Object)applink.getName(), (Object)e.getMessage());
            return new ValidationResultEntity(Collections.emptyList(), Collections.singletonList(new ValidationMessageEntity(this.i18nResolver.getText("usermanagement.apps.communication.error", new Serializable[]{applink.getName(), e.getMessage()}))));
        }
    }
}

