/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;

public class UserProvisioningServiceFunctions {
    private final UserProvisioningService userProvisioningService;

    public static Function<Product, Option<Integer>> calculateAvailableSeatsForProduct(UserProvisioningService userProvisioningService) {
        return new UserProvisioningServiceFunctions(userProvisioningService).calculateAvailableSeatsForProduct();
    }

    public UserProvisioningServiceFunctions(UserProvisioningService userProvisioningService) {
        this.userProvisioningService = userProvisioningService;
    }

    public Function<Product, Option<Integer>> calculateAvailableSeatsForProduct() {
        return new Function<Product, Option<Integer>>(){

            public Option<Integer> apply(Product input) {
                try {
                    if (!input.hasProductConfig().booleanValue()) {
                        return Option.some(0);
                    }
                    return UserProvisioningServiceFunctions.this.userProvisioningService.getAvailableSeatsForProduct(input);
                }
                catch (DirectoryNotFoundException | OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

