/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.rest.util.UserEntityUtil;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupCannotBeDeletedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SysadminGroupModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserCannotBeDeletedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.ValidationService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ValidationResults;
import com.atlassian.crowd.plugin.usermanagement.util.DefaultMessage;
import com.atlassian.crowd.plugin.usermanagement.util.QueryUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ServiceDeskValidationFunctions;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.sal.api.message.Message;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserAndGroupServiceImpl
implements UserAndGroupService {
    private final DirectoryLocator directoryLocator;
    private final DirectoryManager directoryManager;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final ValidationService validationService;
    private final UserProvisioningService userProvisioningService;
    private final ProductService productService;

    public UserAndGroupServiceImpl(DirectoryLocator directoryLocator, DirectoryManager directoryManager, UserAndGroupCheckService userAndGroupCheckService, ValidationService validationService, UserProvisioningService userProvisioningService, ProductService productService) {
        this.directoryLocator = directoryLocator;
        this.directoryManager = directoryManager;
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.validationService = validationService;
        this.userProvisioningService = userProvisioningService;
        this.productService = productService;
    }

    protected long getDirectoryId() {
        return this.directoryLocator.getDirectoryId();
    }

    @Override
    public List<String> getGroupsForUser(String userName) throws DirectoryNotFoundException, OperationFailedException {
        MembershipQuery<String> query = QueryUtils.getMembershipQuery(userName);
        return this.directoryManager.searchNestedGroupRelationships(this.getDirectoryId(), query);
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException, OperationFailedException, SysadminGroupModificationNotAllowedException, UserModificationNotAllowedException {
        Option<ValidationResults> validationResults;
        if (this.userAndGroupCheckService.isCurrentUser(userName) && (validationResults = this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(groupName)).isDefined()) {
            throw new SysadminGroupModificationNotAllowedException((ValidationResults)validationResults.get());
        }
        Option<Message> userValidationResults = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName);
        if (userValidationResults.isDefined()) {
            throw new UserModificationNotAllowedException((Message)userValidationResults.get());
        }
        Option<ValidationResults> validationResults2 = this.userAndGroupCheckService.canCurrentUserModifyGroup(groupName);
        if (validationResults2.isDefined()) {
            throw new SysadminGroupModificationNotAllowedException((ValidationResults)validationResults2.get());
        }
        this.directoryManager.removeUserFromGroup(this.getDirectoryId(), userName, groupName);
    }

    private void addToMap(Map<String, Set<String>> map, String key, String value) {
        Set<String> values = map.get(key);
        if (values == null) {
            values = new HashSet<String>();
            map.put(key, values);
        }
        values.add(value);
    }

    @Override
    public UserEntity getUserEntity(String userName, URI baseUri, boolean expandAttributes) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        Preconditions.checkNotNull((Object)userName);
        Link userLink = LinkUriHelper.buildUserLink(baseUri, userName);
        return UserEntityUtil.expandUser(this.directoryManager, this.getDirectoryId(), UserEntity.newMinimalUserEntity(userName, null, userLink), expandAttributes);
    }

    @Override
    public User getUser(String userName) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        Preconditions.checkNotNull((Object)userName);
        return this.directoryManager.findUserByName(this.getDirectoryId(), userName);
    }

    @Override
    public boolean userExists(String userName) throws DirectoryNotFoundException, OperationFailedException {
        try {
            this.getUser(userName);
            return true;
        }
        catch (UserNotFoundException e) {
            return false;
        }
    }

    @Override
    public List<String> getMembersOfGroup(String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.getMembersOfGroup(groupName, 0, -1);
    }

    @Override
    public BoundedCount countDirectMembersOfGroup(String groupName, int suggestedMaxResults) throws OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        return this.directoryManager.countDirectMembersOfGroup(this.getDirectoryId(), groupName, suggestedMaxResults);
    }

    @Override
    public List<String> getMembersOfGroup(String groupName, int startIndex, int maxResults) throws DirectoryNotFoundException, OperationFailedException {
        MembershipQuery<String> query = QueryUtils.getMembersOfGroupQuery(groupName, startIndex, maxResults);
        return this.directoryManager.searchDirectGroupRelationships(this.getDirectoryId(), query);
    }

    @Override
    public List<String> getAllUsersValidForProductAccess() throws DirectoryNotFoundException, OperationFailedException {
        PropertyRestriction sdRestriction = Restriction.on((Property)PropertyUtils.ofTypeString((String)ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)).isNull();
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{sdRestriction, Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)})).returningAtMost(-1);
        return this.directoryManager.searchUsers(this.getDirectoryId(), query);
    }

    @Override
    public Group getGroup(String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.findGroupByName(this.getDirectoryId(), groupName);
    }

    @Override
    public boolean groupExists(String groupName) throws DirectoryNotFoundException, OperationFailedException {
        try {
            this.getGroup(groupName);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    @Override
    public ValidationResults groupPreDelete(String groupName) throws DirectoryNotFoundException, OperationFailedException, GroupNotFoundException {
        this.getGroup(groupName);
        Option<ValidationResults> validationResults = this.userAndGroupCheckService.canCurrentUserModifyGroup(groupName);
        if (validationResults.isDefined()) {
            return (ValidationResults)validationResults.get();
        }
        List<Product> allProducts = this.productService.fetchProducts();
        validationResults = this.isGroupDefault(allProducts, groupName);
        if (validationResults.isDefined()) {
            return (ValidationResults)validationResults.get();
        }
        validationResults = this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(groupName);
        if (validationResults.isDefined()) {
            return (ValidationResults)validationResults.get();
        }
        return ValidationResults.applicationValidationResults(this.validationService.groupPreDelete(groupName));
    }

    private Option<ValidationResults> isGroupDefault(List<Product> allProducts, String groupName) {
        if (this.productService.hasDefaultAccess(allProducts, groupName)) {
            return Option.some(ValidationResults.errorResult(new DefaultMessage("usermanagement.users.groups.delete.default.error", new Serializable[0])));
        }
        return Option.none();
    }

    @Override
    public ValidationResults userPreDelete(String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.getUser(username);
        Option<Message> validationResults = this.userAndGroupCheckService.canCurrentUserModifyUserData(username);
        if (validationResults.isDefined()) {
            return ValidationResults.errorResult((Message)validationResults.get());
        }
        if (this.userAndGroupCheckService.isCurrentUser(username)) {
            return ValidationResults.errorResult(new DefaultMessage("usermanagement.users.delete.self.error", new Serializable[0]));
        }
        return ValidationResults.applicationValidationResults(this.validationService.userPreDelete(username));
    }

    @Override
    public void deleteUser(String username) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserCannotBeDeletedException {
        ValidationResults validationResults = this.userPreDelete(username);
        if (validationResults.hasErrors()) {
            throw new UserCannotBeDeletedException(validationResults);
        }
        this.directoryManager.removeUser(this.getDirectoryId(), username);
    }

    @Override
    public void deleteGroup(String groupName) throws ReadOnlyGroupException, OperationFailedException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, GroupCannotBeDeletedException {
        ValidationResults validationResults = this.groupPreDelete(groupName);
        if (validationResults.hasErrors()) {
            throw new GroupCannotBeDeletedException(validationResults);
        }
        this.directoryManager.removeGroup(this.getDirectoryId(), groupName);
    }

    @Override
    public Group addGroup(String groupName) throws OperationFailedException, InvalidGroupException, DirectoryNotFoundException, DirectoryPermissionException {
        return this.directoryManager.addGroup(this.getDirectoryId(), new GroupTemplate(groupName, this.getDirectoryId()));
    }
}

