/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.adminchrome.util.AdminChromeSystemProperties;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.service.SendEmailService;
import com.atlassian.crowd.plugin.usermanagement.util.StringFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.UserFunctions;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEmailServiceImpl
implements SendEmailService {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(SendEmailServiceImpl.class);
    private static final String USERMANAGEMENT_KEY = "com.atlassian.crowd.crowd-user-management-plugin";
    private static final String EMAIL_TEMPLATE_KEY = "com.atlassian.crowd.crowd-user-management-plugin:email-user";
    private static final String DEFAULT_EMAIL_TEMPLATE_NAME = "usermanagement.email.template";
    private static final String SIGNUP_NOTIFICATION_TEMPLATE_NAME = "usermanagement.email.signupNotification";
    private static final String RESET_PASSWORD_ACTION = "/users/resetpassword";
    private static final String USERS_SIGN_UP_ACTION = "/users/sign-up";
    private static final int SELF_PASSWORD_RESET_EXPIRY_DAYS = 1;
    private final ForgottenLoginManager forgottenLoginManager;
    private final MailManager mailManager;
    private final I18nResolver i18nResolver;
    private final ApplicationProperties applicationProperties;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ExecutorService executorService;

    public SendEmailServiceImpl(ForgottenLoginManager forgottenLoginManager, MailManager mailManager, I18nResolver i18nResolver, ApplicationProperties applicationProperties, SoyTemplateRenderer soyTemplateRenderer, ExecutorService executorService) {
        this.forgottenLoginManager = (ForgottenLoginManager)Preconditions.checkNotNull((Object)forgottenLoginManager);
        this.mailManager = (MailManager)Preconditions.checkNotNull((Object)mailManager);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.soyTemplateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)soyTemplateRenderer);
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
    }

    @Override
    public void sendCreateUserPasswordEmail(User user, int tokenExpiryDays, String emailTemplateName) throws MailSendException, AddressException, MailServerConfigurationException {
        String resetPasswordUrl = this.buildResetPasswordUrl(user, tokenExpiryDays);
        EmailBuilder emailBuilder = new EmailBuilder().withSubject(this.i18nResolver.getText("usermanagement.users.setpassword.subject", new Serializable[]{user.getDisplayName()})).withBody(this.i18nResolver.getText("usermanagement.users.setpassword.body", new Serializable[]{StringEscapeUtils.escapeHtml4(user.getName()), Integer.valueOf(tokenExpiryDays)})).withPrimaryActionText(this.i18nResolver.getText("usermanagement.users.setpassword.button")).withPrimaryActionLink(resetPasswordUrl).withPlainText(this.i18nResolver.getText("usermanagement.users.setpassword.plaintext", new Serializable[]{user.getName(), resetPasswordUrl}));
        if (StringUtils.isBlank(emailTemplateName)) {
            this.sendEmail(user.getEmailAddress(), emailBuilder);
        } else {
            this.sendEmailWithTemplate(user.getEmailAddress(), emailBuilder, emailTemplateName);
        }
    }

    @Override
    public void sendCreateUserPasswordEmail(User user, int tokenExpiryDays) throws MailSendException, AddressException, MailServerConfigurationException {
        this.sendCreateUserPasswordEmail(user, tokenExpiryDays, null);
    }

    @Override
    public void sendForgotPasswordEmail(User user) throws MailSendException, AddressException, MailServerConfigurationException {
        String resetPasswordUrl = this.buildResetPasswordUrl(user, 1);
        EmailBuilder emailBuilder = new EmailBuilder().withSubject(this.i18nResolver.getText("usermanagement.users.resetpassword.subject")).withBody(this.i18nResolver.getText("usermanagement.users.resetpassword.body", new Serializable[]{StringEscapeUtils.escapeHtml4(user.getName())})).withPrimaryActionText(this.i18nResolver.getText("usermanagement.users.resetpassword.button")).withPrimaryActionLink(resetPasswordUrl).withSecondaryAction(this.i18nResolver.getText("usermanagement.users.resetpassword.secondary", new Serializable[]{this.generateRequestForgotPasswordUrl()})).withPlainText(this.i18nResolver.getText("usermanagement.users.resetpassword.plaintext", new Serializable[]{resetPasswordUrl, this.generateRequestForgotPasswordUrl()}));
        this.sendEmail(user.getEmailAddress(), emailBuilder);
    }

    @Override
    public void sendForgotUsernameEmail(String emailAddress, Collection<User> users) throws AddressException, MailSendException, MailServerConfigurationException {
        EmailBuilder emailBuilder = new EmailBuilder();
        Collection activeUsers = Collections2.filter(users, (Predicate)new Predicate<User>(){

            public boolean apply(User user) {
                return user.isActive();
            }
        });
        if (users.isEmpty()) {
            emailBuilder.withSubject(this.i18nResolver.getText("usermanagement.users.forgotusername.subject")).withBody(this.i18nResolver.getText("usermanagement.users.forgotusername.noaccounts.body")).withPlainText(this.i18nResolver.getText("usermanagement.users.forgotusername.noaccounts.plaintext"));
        } else if (activeUsers.isEmpty()) {
            String listOfUsernamesForHtml = StringUtils.join(Iterables.transform(users, (Function)Functions.compose((Function)Functions.compose(StringFunctions.infixer("<strong>", "</strong>"), StringFunctions.htmlEscaper()), UserFunctions.usernameGetter())), "<br/>");
            String listOfUsernamesForPlaintext = StringUtils.join(Iterables.transform(users, UserFunctions.usernameGetter()), "\n");
            emailBuilder.withSubject(this.i18nResolver.getText("usermanagement.users.forgotusername.subject")).withBody(this.i18nResolver.getText("usermanagement.users.forgotusername.inactive.body", new Serializable[]{listOfUsernamesForHtml})).withPlainText(this.i18nResolver.getText("usermanagement.users.forgotusername.inactive.plaintext", new Serializable[]{listOfUsernamesForPlaintext}));
        } else {
            String listOfUsernamesForHtml = StringUtils.join(Iterables.transform(users, (Function)Functions.compose((Function)Functions.compose(StringFunctions.infixer("<strong>", "</strong>"), StringFunctions.htmlEscaper()), UserFunctions.usernameGetter())), "<br/>");
            String listOfUsernamesForPlaintext = StringUtils.join(Iterables.transform(users, UserFunctions.usernameGetter()), "\n");
            String forgotPasswordUrl = this.generateRequestForgotPasswordUrl();
            String baseUrlWithoutContext = this.getBaseUrlWithoutContext();
            emailBuilder.withSubject(this.i18nResolver.getText("usermanagement.users.forgotusername.subject")).withBody(this.i18nResolver.getText("usermanagement.users.forgotusername.body", new Serializable[]{listOfUsernamesForHtml})).withPrimaryActionText(this.i18nResolver.getText("usermanagement.users.forgotusername.button")).withPrimaryActionLink(forgotPasswordUrl).withSecondaryAction(this.i18nResolver.getText("usermanagement.users.forgotusername.secondary", new Serializable[]{baseUrlWithoutContext})).withPlainText(this.i18nResolver.getText("usermanagement.users.forgotusername.plaintext", new Serializable[]{listOfUsernamesForPlaintext, forgotPasswordUrl, baseUrlWithoutContext}));
        }
        this.sendEmail(emailAddress, emailBuilder);
    }

    @Override
    public void sendSignupNotificationEmail(String email, User user, Map<String, Integer> licenses, String serverName) throws MailServerConfigurationException, MailSendException, AddressException {
        try {
            String username = user.getName();
            String emailAddress = user.getEmailAddress();
            EmailBuilder emailBuilder = new EmailBuilder().withSubject(this.i18nResolver.getText("usermanagement.users.signedup.subject")).withBody(this.soyTemplateRenderer.render(EMAIL_TEMPLATE_KEY, SIGNUP_NOTIFICATION_TEMPLATE_NAME, (Map)ImmutableMap.of((Object)"user", (Object)user, (Object)"licenses", licenses, (Object)"noLicense", (Object)licenses.containsValue(0), (Object)"serverName", (Object)serverName))).withPlainText(this.i18nResolver.getText("usermanagement.users.signedup.plaintext", new Serializable[]{username, emailAddress}));
            this.sendEmail(email, emailBuilder);
        }
        catch (SoyException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendSignUpEmail(String email, String token) throws MailServerConfigurationException, MailSendException, AddressException {
        String baseURL = this.getBaseUrlWithoutContext() + AdminChromeSystemProperties.getContextPath() + AdminChromeSystemProperties.getServletPath();
        String link = baseURL + USERS_SIGN_UP_ACTION + "?token=" + token;
        String signUpAgainLink = baseURL + USERS_SIGN_UP_ACTION;
        EmailBuilder emailBuilder = new EmailBuilder().withSubject(this.i18nResolver.getText("usermanagement.users.signup.subject")).withBody(this.i18nResolver.getText("usermanagement.users.signup.body", new Serializable[]{signUpAgainLink})).withPrimaryActionText(this.i18nResolver.getText("usermanagement.users.signup.button")).withPrimaryActionLink(link).withPlainText(this.i18nResolver.getText("usermanagement.users.signup.plaintext", new Serializable[]{link}));
        this.sendEmail(email, emailBuilder);
    }

    @Override
    public void sendInviteUserEmailExistingUser(User sender, String email) throws AddressException, MailSendException, MailServerConfigurationException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        String name = sender.getDisplayName();
        String link = this.getBaseUrlWithoutContext();
        EmailBuilder emailBuilder = new EmailBuilder().withSubject(this.i18nResolver.getText("usermanagement.users.inviteuser.subject")).withBody(this.i18nResolver.getText("usermanagement.users.inviteuser.existinguser.body", new Serializable[]{StringEscapeUtils.escapeHtml4(name)})).withPrimaryActionText(this.i18nResolver.getText("usermanagement.users.inviteuser.existinguser.button")).withPrimaryActionLink(link).withPlainText(this.i18nResolver.getText("usermanagement.users.inviteuser.existinguser.plaintext", new Serializable[]{name, link}));
        this.sendEmail(email, emailBuilder);
    }

    private void sendEmail(String toEmailAddress, EmailBuilder emailBuilder) throws AddressException, MailSendException, MailServerConfigurationException {
        this.sendEmailWithTemplate(toEmailAddress, emailBuilder, DEFAULT_EMAIL_TEMPLATE_NAME);
    }

    private void sendEmailWithTemplate(String toEmailAddress, final EmailBuilder emailBuilder, String emailTemplateName) throws AddressException, MailSendException, MailServerConfigurationException {
        if (this.mailManager.isConfigured()) {
            try {
                emailBuilder.withFooter(this.i18nResolver.getText("usermanagement.users.email.footer"));
                final String emailBody = this.soyTemplateRenderer.render(EMAIL_TEMPLATE_KEY, emailTemplateName, emailBuilder.asMap());
                final InternetAddress emailAddress = new InternetAddress(toEmailAddress);
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SendEmailServiceImpl.this.mailManager.sendHtmlEmail(emailAddress, emailBuilder.getSubject(), emailBody, emailBuilder.getPlainTextVersion());
                        }
                        catch (MailSendException e) {
                            LOGGER.error("Failed to send email", (Throwable)e);
                        }
                    }
                });
            }
            catch (SoyException e) {
                throw new RuntimeException("Failed to render Soy content. (" + emailTemplateName + ")", e);
            }
            catch (RuntimeException e) {
                if (emailTemplateName.equals(DEFAULT_EMAIL_TEMPLATE_NAME)) {
                    throw new RuntimeException("Failed to render Soy content. (" + emailTemplateName + ")", e);
                }
                LOGGER.warn("Template not found: " + emailTemplateName + ". Falling back to default: " + DEFAULT_EMAIL_TEMPLATE_NAME);
                this.sendEmailWithTemplate(toEmailAddress, emailBuilder, DEFAULT_EMAIL_TEMPLATE_NAME);
            }
        } else {
            LOGGER.error("Unable to send email notifications due to unconfigured mail server");
            throw new MailServerConfigurationException();
        }
    }

    private String buildResetPasswordUrl(User user, int expiryDays) {
        String encDirectoryId;
        String encToken;
        String encUsername;
        ExpirableUserToken resetPasswordToken = this.forgottenLoginManager.createAndStoreResetToken(user.getDirectoryId(), user.getName(), (int)TimeUnit.DAYS.toSeconds(expiryDays));
        String baseURL = this.getBaseUrlWithoutContext() + AdminChromeSystemProperties.getContextPath() + AdminChromeSystemProperties.getServletPath();
        try {
            encUsername = URLEncoder.encode(resetPasswordToken.getUsername(), UTF8_ENCODING);
            encToken = URLEncoder.encode(resetPasswordToken.getToken(), UTF8_ENCODING);
            encDirectoryId = URLEncoder.encode(Long.toString(resetPasswordToken.getDirectoryId()), UTF8_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not encode username and token: this Java VM does not support UTF-8", e);
        }
        return baseURL + RESET_PASSWORD_ACTION + "/" + encDirectoryId + "/" + encToken + "?username=" + encUsername;
    }

    private String generateRequestForgotPasswordUrl() {
        return this.getBaseUrlWithoutContext() + "/login/forgot";
    }

    private String getBaseUrlWithoutContext() {
        String baseURL = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        String context = this.applicationProperties.getBaseUrl(UrlMode.RELATIVE_CANONICAL);
        return baseURL.substring(0, baseURL.lastIndexOf(context));
    }

    private static class EmailBuilder {
        private Map<String, Object> emailArguments = Maps.newHashMap();

        private EmailBuilder() {
        }

        public EmailBuilder withSubject(String subject) {
            this.emailArguments.put("subject", subject);
            return this;
        }

        public EmailBuilder withBody(String body) {
            this.emailArguments.put("body", body);
            return this;
        }

        public EmailBuilder withPrimaryActionText(String primaryAction) {
            this.emailArguments.put("primaryActionText", primaryAction);
            return this;
        }

        public EmailBuilder withPrimaryActionLink(String resetPasswordUrl) {
            this.emailArguments.put("primaryActionLink", resetPasswordUrl);
            return this;
        }

        public EmailBuilder withSecondaryAction(String secondaryAction) {
            this.emailArguments.put("secondaryAction", secondaryAction);
            return this;
        }

        public EmailBuilder withPlainText(String plainText) {
            this.emailArguments.put("plaintext", plainText);
            return this;
        }

        public EmailBuilder withFooter(String footer) {
            this.emailArguments.put("footer", footer);
            return this;
        }

        public String getSubject() {
            return this.emailArguments.get("subject").toString();
        }

        public String getPlainTextVersion() {
            return this.emailArguments.get("plaintext").toString();
        }

        public Map<String, Object> asMap() {
            return this.emailArguments;
        }
    }
}

