/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordPolicyEntity;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.PasswordPolicyService;
import com.atlassian.crowd.plugin.usermanagement.util.Constants;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPolicyServiceImpl
implements PasswordPolicyService {
    private final PluginSettings pluginSettings;
    private final DirectoryManager directoryManager;
    private final DirectoryLocator directoryLocator;
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyServiceImpl.class);
    private static final String LAST_PASSWORD_RESET = "passwordPolicy.lastReset";

    public PasswordPolicyServiceImpl(PluginSettingsFactory pluginSettingsFactory, DirectoryManager directoryManager, DirectoryLocator directoryLocator) {
        this.directoryManager = directoryManager;
        this.directoryLocator = directoryLocator;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public PasswordScore getPolicyScore() {
        Directory directory = this.directoryLocator.getDirectory();
        String policyString = (String)directory.getAttributes().get("password_minimum_score");
        if (StringUtils.isNotBlank(policyString)) {
            try {
                return PasswordScore.fromRanking((long)Long.parseLong(policyString));
            }
            catch (NumberFormatException e) {
                log.error("Database has invalid values for policy score");
            }
        }
        return Constants.DEFAULT_POLICY_SCORE_VALUE;
    }

    @Override
    public void setPolicyScore(PasswordScore policyScore) {
        DirectoryImpl directory = new DirectoryImpl(this.directoryLocator.getDirectory());
        directory.setAttribute("password_minimum_score", String.valueOf(policyScore.getRanking()));
        try {
            this.directoryManager.updateDirectory((Directory)directory);
        }
        catch (DirectoryNotFoundException dnfe) {
            throw new RuntimeException(dnfe);
        }
    }

    @Override
    public int getExpiry() {
        Directory directory = this.directoryLocator.getDirectory();
        String policyString = (String)directory.getAttributes().get("password_max_change_time");
        if (StringUtils.isNotBlank(policyString)) {
            try {
                return Integer.parseInt(policyString);
            }
            catch (NumberFormatException e) {
                log.error("Crowd has invalid values for policy expiry");
            }
        }
        return 0;
    }

    @Override
    public void setExpiry(int expiry) {
        DirectoryImpl directory = new DirectoryImpl(this.directoryLocator.getDirectory());
        directory.setAttribute("password_max_change_time", String.valueOf(expiry));
        try {
            this.directoryManager.updateDirectory((Directory)directory);
        }
        catch (DirectoryNotFoundException dnfe) {
            throw new RuntimeException(dnfe);
        }
    }

    @Override
    public PasswordPolicyEntity getPasswordPolicy() {
        return new PasswordPolicyEntity(this.getPolicyScore(), this.getExpiry(), this.getLastResetTime(), this.getMinimumPasswordRotation());
    }

    @Override
    public void resetAllPasswords() throws OperationFailedException {
        long directoryId = this.directoryLocator.getDirectoryId();
        try {
            if (!this.directoryManager.supportsExpireAllPasswords(directoryId)) {
                log.error("Directory does not support expiring passwords");
                throw new OperationFailedException();
            }
            this.directoryManager.expireAllPasswords(directoryId);
            this.pluginSettings.put(LAST_PASSWORD_RESET, (Object)String.valueOf(System.currentTimeMillis()));
        }
        catch (DirectoryNotFoundException dnfe) {
            throw new RuntimeException(dnfe);
        }
    }

    @Override
    public long getLastResetTime() {
        String resetString = (String)this.pluginSettings.get(LAST_PASSWORD_RESET);
        if (StringUtils.isNotBlank(resetString)) {
            try {
                return Long.valueOf(resetString);
            }
            catch (NumberFormatException e) {
                log.error("Database has invalid values for last reset");
            }
        }
        return 0L;
    }

    @Override
    public int getMinimumPasswordRotation() {
        Directory directory = this.directoryLocator.getDirectory();
        String policyString = (String)directory.getAttributes().get("password_history_count");
        try {
            return Integer.parseInt(policyString);
        }
        catch (NumberFormatException e) {
            log.error("Crowd has invalid values for history count");
            return 0;
        }
    }

    @Override
    public void setMinimumPasswordRotation(int minimumPasswordRotation) {
        DirectoryImpl directory = new DirectoryImpl(this.directoryLocator.getDirectory());
        directory.setAttribute("password_history_count", String.valueOf(minimumPasswordRotation));
        try {
            this.directoryManager.updateDirectory((Directory)directory);
        }
        catch (DirectoryNotFoundException dnfe) {
            throw new RuntimeException(dnfe);
        }
    }
}

