/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.usermanagement.client.config.CrowdAttributesService;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class GroupAttributesService
implements CrowdAttributesService {
    private final DirectoryManager directoryManager;
    private final DirectoryLocator directoryLocator;

    public GroupAttributesService(DirectoryManager directoryManager, DirectoryLocator directoryLocator) {
        this.directoryManager = directoryManager;
        this.directoryLocator = directoryLocator;
    }

    @Override
    public Set<String> getGroupsWithAttribute(String requiredAttribute) {
        try {
            List groupList = this.directoryManager.searchGroups(this.directoryLocator.getDirectoryId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)requiredAttribute)).exactlyMatching((Object)Boolean.TRUE.toString())).returningAtMost(-1));
            return ImmutableSet.copyOf((Collection)groupList);
        }
        catch (CrowdException e) {
            throw new RuntimeException("Unable to query groups with attributes", e);
        }
    }

    @Override
    public void addAttribute(String groupName, String attributeName) {
        try {
            HashMap<String, ImmutableSet> attributes = new HashMap<String, ImmutableSet>();
            attributes.put(attributeName, ImmutableSet.of((Object)"true"));
            this.directoryManager.storeGroupAttributes(this.directoryLocator.getDirectoryId(), groupName, attributes);
        }
        catch (CrowdException e) {
            throw new RuntimeException("Unable to add attribute", e);
        }
        catch (DirectoryPermissionException e) {
            throw new RuntimeException("Unable to add attribute", e);
        }
    }

    @Override
    public void removeAttribute(String groupName, String attributeName) {
        try {
            this.directoryManager.removeGroupAttributes(this.directoryLocator.getDirectoryId(), groupName, attributeName);
        }
        catch (CrowdException e) {
            throw new RuntimeException("Unable to remove attributes", e);
        }
        catch (DirectoryPermissionException e) {
            throw new RuntimeException("Unable to remove attributes", e);
        }
    }

    @Override
    public void removeAttribute(Set<String> groupNames, String attributeName) {
        for (String groupName : groupNames) {
            this.removeAttribute(groupName, attributeName);
        }
    }
}

