/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.ProductController;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.usermanagement.client.entity.ProductUsageEntity;
import com.atlassian.usermanagement.client.entity.UsageHostsEntity;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="usage")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ProductUsageResource
extends BaseResource {
    private final ProductController productController;

    public ProductUsageResource(ProductController productController) {
        this.productController = productController;
    }

    @GET
    public Response getUsage() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        List<ProductUsageEntity> applicationUsage = this.productController.getProductUsage();
        return ResponseFactory.ok(applicationUsage).build();
    }

    @GET
    @Path(value="users")
    @AnonymousAllowed
    public Response getUsers(@QueryParam(value="expand") @DefaultValue(value="false") boolean expand) throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        UsageHostsEntity applicationUsage = this.productController.getUsageHostsEntity();
        if (!expand) {
            applicationUsage = applicationUsage.copyWithoutUsernames();
        }
        return ResponseFactory.ok(applicationUsage).build();
    }
}

