/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ProductDetailsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.HostApplicationNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAppAccessUpdateException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductNotConfigurableException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.ProductServiceImpl;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.products.HostedProduct;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.config.CrowdAttributesService;
import com.atlassian.usermanagement.client.entity.GroupAttributesEntity;
import com.atlassian.usermanagement.client.entity.host.HostEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="accessconfig")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@FeatureGuard(value="um.renaissance")
public class AppAccessConfigResource
extends BaseResource {
    private final ProductService productService;
    private final UserProvisioningService userProvisioningService;
    private final I18nResolver i18nResolver;
    private final CrowdAttributesService crowdAttributesService;
    private boolean showSysAdmin = false;

    public AppAccessConfigResource(ProductService productService, I18nResolver i18nResolver, UserProvisioningService userProvisioningService, CrowdAttributesService crowdAttributesService) {
        this.userProvisioningService = userProvisioningService;
        this.crowdAttributesService = crowdAttributesService;
        this.productService = (ProductService)Preconditions.checkNotNull((Object)productService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    @GET
    public Response getConfig() throws Exception {
        ArrayList<ProductDetailsEntity> productEntities = new ArrayList<ProductDetailsEntity>();
        List<Product> products = this.productService.fetchProducts();
        for (Product productObject : products) {
            productEntities.add(this.generateProductEntity(productObject));
        }
        return ResponseFactory.ok(new ConfigEntity(productEntities)).build();
    }

    @GET
    @Path(value="products")
    public Response getConfiguration(@QueryParam(value="hostId") String hostId) throws HostApplicationNotFoundException {
        Option<HostEntity> maybeHost;
        if (hostId != null && (maybeHost = this.productService.retrieve(hostId)).isDefined()) {
            return ResponseFactory.ok().entity(maybeHost.get()).build();
        }
        throw new HostApplicationNotFoundException(hostId);
    }

    @POST
    @Path(value="revoke-all-access")
    @ResourceFilters(value={SysadminOnlyResourceFilter.class})
    public Response revokeAllAccess(@QueryParam(value="exceptGroups") List<String> groupNames) {
        if (groupNames == null) {
            groupNames = new ArrayList<String>();
        }
        this.productService.revokeAllAccess(groupNames);
        return ResponseFactory.noContent().build();
    }

    @POST
    @Path(value="group/approval")
    public Response approveAccess(@QueryParam(value="hostId") String hostId, @QueryParam(value="productId") ProductId productId, @QueryParam(value="groupname") String groupName) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)productId);
        Preconditions.checkNotNull((Object)groupName);
        this.productService.approveAccess(productId, groupName, this.userProvisioningService);
        return ResponseFactory.ok("{\"message\":\"updated\"}").build();
    }

    @DELETE
    @Path(value="group/approval")
    public Response rejectAccess(@QueryParam(value="hostId") String hostId, @QueryParam(value="productId") ProductId productId, @QueryParam(value="groupname") String groupName) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        Preconditions.checkNotNull((Object)hostId);
        Preconditions.checkNotNull((Object)productId);
        Preconditions.checkNotNull((Object)groupName);
        this.productService.rejectAccess(productId, groupName, this.userProvisioningService);
        return ResponseFactory.ok("{\"message\":\"updated\"}").build();
    }

    @DELETE
    @Path(value="products")
    public Response deleteConfiguration(@QueryParam(value="hostId") String hostId) throws HostApplicationNotFoundException, IOException {
        Option<HostEntity> maybeHost;
        if (hostId != null && (maybeHost = this.productService.retrieve(hostId)).isDefined()) {
            this.productService.deleteHostConfig(hostId);
            return ResponseFactory.noContent().build();
        }
        throw new HostApplicationNotFoundException(hostId);
    }

    @PUT
    @Path(value="group")
    public Response updateGroup(@QueryParam(value="hostId") String hostId, @QueryParam(value="productId") String productId, ProductDetailsEntity.GroupEntity groupEntity) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException {
        if (groupEntity != null && groupEntity.getName() != null) {
            String group = groupEntity.getName();
            switch (groupEntity.getUse()) {
                case DIRECT: {
                    this.productService.grantAccess(new ProductId(productId), group, AccessLevel.USE, this.userProvisioningService);
                    break;
                }
                case NONE: {
                    this.productService.revokeAccess(new ProductId(productId), group, AccessLevel.USE);
                }
            }
            switch (groupEntity.getAdmin()) {
                case DIRECT: {
                    this.productService.grantAccess(new ProductId(productId), group, AccessLevel.ADMIN, this.userProvisioningService);
                    break;
                }
                case NONE: {
                    this.productService.revokeAccess(new ProductId(productId), group, AccessLevel.ADMIN);
                }
            }
            if (groupEntity.isDefaultUse()) {
                this.productService.grantDefaultAccess(new ProductId(productId), group, this.userProvisioningService);
            } else {
                this.productService.removeDefaultAccess(new ProductId(productId), group);
            }
        }
        return ResponseFactory.ok("{\"message\":\"updated\"}").build();
    }

    @POST
    @Path(value="group")
    public Response grantAccessToGroup(@QueryParam(value="hostId") String hostId, @QueryParam(value="productId") ProductId productId, List<String> groupNames) throws ProductNotFoundException, ProductNotConfigurableException, ProductAppAccessUpdateException, LicenseExceededException {
        Product product = (Product)this.productService.getProduct(productId).getOrThrow(new ProductServiceImpl.ProductNotFoundSupplier(productId));
        ArrayList<ProductDetailsEntity.GroupEntity> response = new ArrayList<ProductDetailsEntity.GroupEntity>();
        for (String group : groupNames) {
            response.add(new ProductDetailsEntity.GroupEntity(group, ProductDetailsEntity.Access.DIRECT, product.isPlatform() ? ProductDetailsEntity.Access.NONE : ProductDetailsEntity.Access.DISABLED, false));
            this.productService.grantAccess(productId, group, AccessLevel.USE, this.userProvisioningService);
        }
        return ResponseFactory.ok(response).build();
    }

    protected ProductDetailsEntity generateProductEntity(Product product) {
        Either<ProductAccessError, ProductConfig> maybeConfig = product.fetchProductConfig();
        if (maybeConfig.isRight()) {
            ProductConfig productConfig = (ProductConfig)maybeConfig.right().get();
            ArrayList<ProductDetailsEntity.GroupEntity> groups = new ArrayList<ProductDetailsEntity.GroupEntity>();
            Map<String, GroupAttributesEntity> useGroups = productConfig.getGroupPermissions(AccessLevel.USE);
            Map<Object, Object> adminGroups = productConfig.isPlatformProduct() != false ? productConfig.getGroupPermissions(AccessLevel.ADMIN) : new HashMap();
            Map<Object, Object> sysadminGroups = productConfig.isPlatformProduct() != false ? productConfig.getGroupPermissions(AccessLevel.SYSADMIN) : new HashMap();
            for (String groupName : Sets.union(useGroups.keySet(), adminGroups.keySet())) {
                if (!this.showSysAdmin && sysadminGroups.containsKey(groupName)) continue;
                boolean use = useGroups.containsKey(groupName);
                boolean admin = adminGroups.containsKey(groupName);
                groups.add(new ProductDetailsEntity.GroupEntity(groupName, ProductDetailsEntity.Access.fromBoolean(use), ProductDetailsEntity.Access.fromBoolean(admin, productConfig.isPlatformProduct() == false), use && useGroups.get(groupName).isDefault()));
            }
            ArrayList<ProductDetailsEntity.GroupEntity> groupsRequiringApproval = new ArrayList<ProductDetailsEntity.GroupEntity>();
            if (product instanceof HostedProduct) {
                Set<String> useGroupsRequiringApproval = this.productService.getGroupsRequiringApproval(product, AccessLevel.USE, false);
                Set<String> defaultGroupsRequiringApproval = this.productService.getGroupsRequiringApproval(product, AccessLevel.USE, true);
                Set<String> adminGroupsRequiringApproval = this.productService.getGroupsRequiringApproval(product, AccessLevel.ADMIN, false);
                for (String groupName : Sets.union(useGroupsRequiringApproval, adminGroupsRequiringApproval)) {
                    boolean use = useGroupsRequiringApproval.contains(groupName);
                    boolean isDefault = defaultGroupsRequiringApproval.contains(groupName);
                    boolean admin = adminGroupsRequiringApproval.contains(groupName);
                    groupsRequiringApproval.add(new ProductDetailsEntity.GroupEntity(groupName, ProductDetailsEntity.Access.fromBoolean(use), ProductDetailsEntity.Access.fromBoolean(admin), isDefault));
                }
            }
            return new ProductDetailsEntity.Builder(product.getHostId(), product.getProductId(), product.getProductName(), productConfig.getPlatformProductName(), product.getPermissionsUrl()).groups(groups).groupsRequiringApproval(groupsRequiringApproval).configurable(productConfig.isConfigurable()).platform(productConfig.isPlatformProduct()).build();
        }
        return new ProductDetailsEntity.Builder(product.getHostId(), product.getProductId(), product.getProductName(), product.getProductName(), product.getPermissionsUrl()).platform(true).errors(ErrorEntity.withGenericError(((ProductAccessError)product.fetchProductConfig().left().get()).getReason())).build();
    }

    @JsonAutoDetect
    public static class ConfigEntity {
        @JsonProperty
        private List<ProductDetailsEntity> products;

        @JsonCreator
        public ConfigEntity(@JsonProperty(value="products") List<ProductDetailsEntity> products) {
            this.products = products;
        }

        public List<ProductDetailsEntity> getProducts() {
            return this.products;
        }
    }
}

