/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ProductAccessErrorExceptionMapper
implements ExceptionMapper<ProductAccessErrorException> {
    private final I18nResolver i18nResolver;

    public ProductAccessErrorExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(ProductAccessErrorException e) {
        return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntity.withGenericError(Collections2.transform(e.getInfo().entrySet(), (Function)new Function<Map.Entry<Product, ProductAccessError>, String>(){

            public String apply(Map.Entry<Product, ProductAccessError> input) {
                return ProductAccessErrorExceptionMapper.this.i18nResolver.getText("usermanagement.apps.generic.error", new Serializable[]{input.getKey().getProductName(), input.getValue().getReason()});
            }
        }))).build();
    }
}

