/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.directory.PasswordLengthConstraint;
import com.atlassian.crowd.directory.PasswordScoreConstraint;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class InvalidCredentialExceptionMapper
implements ExceptionMapper<InvalidCredentialException> {
    private final I18nResolver i18nResolver;

    public InvalidCredentialExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(InvalidCredentialException e) {
        if (e.getViolatedConstraints() == null || e.getViolatedConstraints().isEmpty()) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.of((Throwable)e)).build();
        }
        ImmutableList.Builder constraintStrings = ImmutableList.builder();
        for (PasswordConstraint constraint : e.getViolatedConstraints()) {
            if (constraint instanceof PasswordScoreConstraint) {
                constraintStrings.add((Object)this.i18nResolver.getText("usermanagement.passwordpolicy.constraint.violation.strength"));
                continue;
            }
            if (constraint instanceof PasswordLengthConstraint) {
                PasswordLengthConstraint lengthConstraint = (PasswordLengthConstraint)constraint;
                constraintStrings.add((Object)this.i18nResolver.getText("usermanagement.passwordpolicy.constraint.violation.length", new Serializable[]{Integer.valueOf(lengthConstraint.getMinimumLength())}));
                continue;
            }
            constraintStrings.add((Object)this.i18nResolver.getText("usermanagement.passwordpolicy.constraint.violation.unknown"));
        }
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError((Iterable<String>)constraintStrings.build())).build();
    }
}

