/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class RestGroupEntity {
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private String type;
    @JsonProperty
    private boolean active;
    @JsonProperty
    private boolean isUnmodifiable;
    @JsonProperty
    private boolean isLastAdminGroup;
    @JsonProperty
    private Link link;
    @JsonProperty
    private List<LozengeEntity> lozenges;

    public RestGroupEntity(String name, String description, String type, boolean active, boolean isUnmodifiable, boolean isLastAdminGroup, Link link) {
        this(name, description, type, active, isUnmodifiable, isLastAdminGroup, link, new ArrayList<LozengeEntity>());
    }

    public RestGroupEntity(String name, String description, String type, boolean active, boolean isUnmodifiable, boolean isLastAdminGroup, Link link, List<LozengeEntity> lozenges) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.active = active;
        this.isUnmodifiable = isUnmodifiable;
        this.isLastAdminGroup = isLastAdminGroup;
        this.link = link;
        this.lozenges = lozenges;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public boolean isLastAdminGroup() {
        return this.isLastAdminGroup;
    }

    @JsonProperty(value="isDefaultGroup")
    public boolean isDefaultGroup() {
        for (LozengeEntity lozenge : this.lozenges) {
            if (!LozengeEntity.Type.DEFAULT.equals((Object)lozenge.getType())) continue;
            return true;
        }
        return false;
    }

    public Link getLink() {
        return this.link;
    }

    public List<LozengeEntity> getLozenges() {
        return this.lozenges;
    }

    public void addLozenge(LozengeEntity link) {
        if (this.lozenges == null) {
            this.lozenges = new ArrayList<LozengeEntity>();
        }
        this.lozenges.add(link);
    }

    public static RestGroupEntity fromGroup(Group group, URI baseURI) {
        return RestGroupEntity.newRestGroupEntity(group.getName(), group.getDescription(), group.isActive(), false, false, baseURI);
    }

    public static RestGroupEntity newMinimalRestGroupEntity(String name, URI baseURI, boolean isUnmodifiable, boolean isLastAdminGroup) {
        return RestGroupEntity.newRestGroupEntity(name, null, true, isUnmodifiable, isLastAdminGroup, baseURI);
    }

    public static RestGroupEntity newRestGroupEntity(String name, String description, boolean active, boolean isUnmodifiable, boolean isLastAdminGroup, URI baseURI) {
        return new RestGroupEntity(name, description, GroupType.GROUP.name(), active, isUnmodifiable, isLastAdminGroup, LinkUriHelper.buildGroupLink(baseURI, name));
    }

    public String toString() {
        return "RestGroupEntity{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", type='" + this.type + '\'' + ", active=" + this.active + ", isUnmodifiable=" + this.isUnmodifiable + ", isLastAdminGroup=" + this.isLastAdminGroup + ", link=" + this.link + ", lozenges=" + this.lozenges + '}';
    }
}

