/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.util.StringFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.UserInvite;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class QuickAddRequestEntity {
    private static final int DEFAULT_EXPIRY_DAYS = 7;
    private final List<String> emails;
    private final List<String> names;

    @JsonCreator
    public QuickAddRequestEntity(@JsonProperty(value="emails") List<String> emails, @JsonProperty(value="names") List<String> names) {
        this.emails = emails;
        this.names = names;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    @JsonIgnore
    public int getExpiryDays() {
        return 7;
    }

    public List<String> getNames() {
        return this.names;
    }

    @JsonIgnore
    public List<UserInvite> buildInvite() {
        Collection emailAddresses = Collections2.transform(this.emails, StringFunctions.toLowerCase());
        Iterable pairIterable = Iterables.zip(emailAddresses, this.names);
        ImmutableList.Builder userInviteBuilder = ImmutableList.builder();
        for (Pair addressAndNames : pairIterable) {
            userInviteBuilder.add((Object)new UserInvite((String)addressAndNames.left(), Option.some(addressAndNames.right())));
        }
        return userInviteBuilder.build();
    }
}

