/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class ProductDetailsEntity {
    private String hostId;
    private String productId;
    private String name;
    private SortedSet<GroupEntity> groups;
    private SortedSet<GroupEntity> groupsRequiringApproval;
    private boolean configurable;
    private boolean platform;
    private String platformProductName;
    private String permissionsUrl;
    private ErrorEntity errors;

    @JsonCreator
    private ProductDetailsEntity(@JsonProperty(value="hostId") String hostId, @JsonProperty(value="productId") String productId, @JsonProperty(value="name") String name, @JsonProperty(value="groups") Collection<GroupEntity> groups, @JsonProperty(value="groupsRequiringApproval") Collection<GroupEntity> groupsRequiringApproval, @JsonProperty(value="configurable") boolean configurable, @JsonProperty(value="platform") boolean platform, @JsonProperty(value="platformProductName") String platformProductName, @JsonProperty(value="permissionsUrl") String permissionsUrl, @JsonProperty(value="errors") ErrorEntity errors) {
        this.hostId = hostId;
        this.productId = productId;
        this.name = name;
        this.groups = new TreeSet<GroupEntity>(groups);
        this.groupsRequiringApproval = new TreeSet<GroupEntity>(groupsRequiringApproval);
        this.configurable = configurable;
        this.platform = platform;
        this.platformProductName = platformProductName;
        this.permissionsUrl = permissionsUrl;
        this.errors = errors;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getName() {
        return this.name;
    }

    public Set<GroupEntity> getGroups() {
        return this.groups;
    }

    public SortedSet<GroupEntity> getGroupsRequiringApproval() {
        return this.groupsRequiringApproval;
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    public boolean isPlatform() {
        return this.platform;
    }

    public String getPlatformProductName() {
        return this.platformProductName;
    }

    public String getPermissionsUrl() {
        return this.permissionsUrl;
    }

    public ErrorEntity getErrors() {
        return this.errors;
    }

    public static class Builder {
        private final String hostId;
        private final String productId;
        private final String name;
        private List<GroupEntity> groups;
        private List<GroupEntity> groupsRequiringApproval;
        private boolean configurable;
        private boolean platform;
        private final String platformProductName;
        private final String permissionsUrl;
        private ErrorEntity errors;

        public Builder(String hostId, ProductId productId, String name, String platformProductName, String permissionsUrl) {
            this.hostId = hostId;
            this.productId = productId.toString();
            this.name = name;
            this.groups = new ArrayList<GroupEntity>();
            this.groupsRequiringApproval = new ArrayList<GroupEntity>();
            this.platformProductName = platformProductName;
            this.permissionsUrl = permissionsUrl;
        }

        public Builder groups(List<GroupEntity> groups) {
            this.groups = groups;
            return this;
        }

        public Builder groupsRequiringApproval(List<GroupEntity> groupsRequiringApproval) {
            this.groupsRequiringApproval = groupsRequiringApproval;
            return this;
        }

        public Builder configurable(boolean configurable) {
            this.configurable = configurable;
            return this;
        }

        public Builder platform(boolean platform) {
            this.platform = platform;
            return this;
        }

        public Builder errors(ErrorEntity errors) {
            this.errors = errors;
            return this;
        }

        public ProductDetailsEntity build() {
            return new ProductDetailsEntity(this.hostId, this.productId, this.name, this.groups, this.groupsRequiringApproval, this.configurable, this.platform, this.platformProductName, this.permissionsUrl, this.errors);
        }
    }

    public static enum Access {
        DISABLED,
        NONE,
        DIRECT;


        public static Access fromBoolean(boolean access) {
            return access ? DIRECT : NONE;
        }

        public static Access fromBoolean(boolean access, boolean disabled) {
            return disabled ? DISABLED : Access.fromBoolean(access);
        }
    }

    @JsonAutoDetect
    public static class GroupEntity
    implements Comparable<GroupEntity> {
        private String name;
        private Access use;
        private Access admin;
        private boolean defaultUse;

        @JsonCreator
        public GroupEntity(@JsonProperty(value="name") String name, @JsonProperty(value="use") Access use, @JsonProperty(value="admin") Access admin, @JsonProperty(value="defaultUse") boolean defaultUse) {
            this.name = name;
            this.use = use;
            this.admin = admin;
            this.defaultUse = defaultUse;
        }

        public String getName() {
            return this.name;
        }

        public Access getUse() {
            return this.use;
        }

        public Access getAdmin() {
            return this.admin;
        }

        public boolean isDefaultUse() {
            return this.defaultUse;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupEntity that = (GroupEntity)o;
            if (this.defaultUse != that.defaultUse) {
                return false;
            }
            if (this.admin != that.admin) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.use == that.use;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.use != null ? this.use.hashCode() : 0);
            result = 31 * result + (this.admin != null ? this.admin.hashCode() : 0);
            result = 31 * result + (this.defaultUse ? 1 : 0);
            return result;
        }

        @Override
        public int compareTo(GroupEntity other) {
            Preconditions.checkNotNull((Object)other);
            return this.getName().compareTo(other.getName());
        }
    }
}

