/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.common.UriBuilder;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.GroupController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.BambooRenameEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.BulkAppAccessOperationResult;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.FullViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ListViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PublicSignUpFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.RestGroupEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.RestGroupEntityList;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UserFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailAlreadyExistsException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.InvalidInvitationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MembershipChangeCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.NoDefaultGroupException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ProductAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SignupNotEnabledException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.util.MessageHelper;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.AtlassianIdService;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.GrantProductAccessResult;
import com.atlassian.crowd.plugin.usermanagement.service.InvitationService;
import com.atlassian.crowd.plugin.usermanagement.service.ProductId;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.SendEmailService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningServiceFunctions;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductUtils;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenceExceedOnActivationPredicateFactory;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.DefaultMessage;
import com.atlassian.crowd.plugin.usermanagement.util.ExplicitOrdering;
import com.atlassian.crowd.plugin.usermanagement.util.FailureUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ServiceDeskValidationFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.UserInvite;
import com.atlassian.crowd.plugin.usermanagement.util.UserTemplateBuilder;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.SignupSettingsService;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.util.ImmutableMapUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserController
extends BaseController {
    private static final int SELF_INVITE_EXPIRY_SECONDS = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final Random USERNAME_RANDOM_GENERATOR = new Random();
    private static final int SMALL_RANGE_FOR_SUFFIXES = 100;
    private static final int SEQUENTIAL_LIMIT_FOR_SUFFIXES = 20;
    private static final String CROSS_PRODUCT_ADMINS = "site-admins";
    private static final String USERS_FILTER = "users";
    private static final String INVITATION_SEND_DATE = "invitationSendDate";
    private static final String INVITATION_EXPIRY_DATE = "invitationExpiryDate";
    @VisibleForTesting
    static final String AID_INTEGRATION_FEATURE_KEY = "um.aid.integration";
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    public static final String ALL_USERS = "all";
    @VisibleForTesting
    static final String AGNI_GAPPS_USER_STATE_ATTRIBUTE_KEY = "agni.gapps.user.state";
    @VisibleForTesting
    static final String ACTIVATED_ATTRIBUTE_VALUE = "activated";
    private final DirectoryManager directoryManager;
    private final SendEmailService sendEmailService;
    private final ForgottenLoginManager forgottenLoginManager;
    private final ApplicationLinkFilteringService applicationLinkService;
    private final UserProvisioningService userProvisioningService;
    private final UserAndGroupService userAndGroupService;
    private final InvitationService invitationService;
    private final UserManager userManager;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final SignupSettingsService signupSettingsService;
    private final ProductService productService;
    private final AtlassianIdService atlassianIdService;
    private final DarkFeatureManager darkFeatureManager;
    private final Function<Product, String> PRODUCT_TO_NAME = new Function<Product, String>(){

        public String apply(Product product) {
            return product.getProductName();
        }
    };
    private final Predicate<String> USERNAME_EXISTS_PREDICATE = new Predicate<String>(){

        public boolean apply(String username) {
            try {
                return UserController.this.userAndGroupService.userExists(username);
            }
            catch (DirectoryNotFoundException | OperationFailedException e) {
                throw new CrowdRuntimeException(e);
            }
        }
    };

    public UserController(DirectoryLocator directoryLocator, DirectoryManager directoryManager, SendEmailService sendEmailService, ForgottenLoginManager forgottenLoginManager, ApplicationLinkFilteringService applicationLinkService, UserProvisioningService userProvisioningService, UserAndGroupService userAndGroupService, I18nResolver i18nResolver, InvitationService invitationService, UserManager userManager, UserAndGroupCheckService userAndGroupCheckService, SignupSettingsService signupSettingsService, ProductService productService, AtlassianIdService atlassianIdService, DarkFeatureManager darkFeatureManager) {
        super(directoryLocator, i18nResolver);
        this.productService = productService;
        this.userAndGroupCheckService = (UserAndGroupCheckService)Preconditions.checkNotNull((Object)userAndGroupCheckService);
        this.applicationLinkService = (ApplicationLinkFilteringService)Preconditions.checkNotNull((Object)applicationLinkService);
        this.userProvisioningService = (UserProvisioningService)Preconditions.checkNotNull((Object)userProvisioningService);
        this.userAndGroupService = (UserAndGroupService)Preconditions.checkNotNull((Object)userAndGroupService);
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
        this.sendEmailService = (SendEmailService)Preconditions.checkNotNull((Object)sendEmailService);
        this.forgottenLoginManager = (ForgottenLoginManager)Preconditions.checkNotNull((Object)forgottenLoginManager);
        this.invitationService = (InvitationService)Preconditions.checkNotNull((Object)invitationService);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.signupSettingsService = (SignupSettingsService)Preconditions.checkNotNull((Object)signupSettingsService);
        this.atlassianIdService = (AtlassianIdService)Preconditions.checkNotNull((Object)atlassianIdService);
        this.darkFeatureManager = (DarkFeatureManager)Preconditions.checkNotNull((Object)darkFeatureManager);
    }

    public UserEntity getUser(String userName, URI baseUri) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException {
        UserEntity userEntity = this.userAndGroupService.getUserEntity(userName, baseUri, true);
        Map<String, AccessLevel> transform = this.translateAccessLevelRepresentation(this.userProvisioningService.getAccessLevel(userName, this.productService.fetchProducts()));
        Option<Message> accessMessage = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName);
        Option<Message> dataMessage = this.userAndGroupCheckService.canCurrentUserModifyUserData(userName);
        LozengeEntity lozenge = this.userAndGroupCheckService.getUserLozenge(userEntity).getOrNull();
        User user = this.directoryManager.findUserByName(this.getDirectoryId(), userName);
        return new FullViewUser(userEntity, (Map<String, AccessLevel>)ImmutableMap.copyOf(transform), accessMessage.isDefined(), dataMessage.isDefined(), MessageHelper.getDisabledMessage(accessMessage, dataMessage, this.i18nResolver), lozenge, this.userAndGroupCheckService.isCurrentUser(userName), user, this.getAIDFromUser(userName).getOrNull());
    }

    public UserEntity addUser(UserFormEntity userFormEntity, URI baseURI, String continueUrl) throws DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserAlreadyExistsException, InvalidUserException, InvalidCredentialException, InvalidEmailAddressException, UserNotFoundException, IOException, GroupNotFoundException, ReadOnlyGroupException, MembershipAlreadyExistsException, ResponseException, LicenseExceededException, ProductAccessErrorException, MailServerConfigurationException, EmailAlreadyExistsException {
        String email = userFormEntity.getEmail();
        boolean useAtlassianId = this.darkFeatureManager.isFeatureEnabledForAllUsers(AID_INTEGRATION_FEATURE_KEY);
        PasswordEntity password = userFormEntity.getPassword();
        Iterable<ProductId> productIds = userFormEntity.getProductIds();
        boolean sendNotification = userFormEntity.getSendNotification();
        int tokenExpiryDays = userFormEntity.getExpiryDays();
        String personalNote = userFormEntity.getText();
        String emailTemplateName = userFormEntity.getTemplate();
        if (this.emailExists(email)) {
            throw new EmailAlreadyExistsException(email);
        }
        if (!useAtlassianId && !sendNotification && password == null) {
            throw new InvalidCredentialException(this.i18nResolver.getText("usermanagement.validation.password.missing"));
        }
        UserTemplateWithAttributes userTemplate = UserController.newUserTemplate(userFormEntity, this.getDirectoryId());
        if (sendNotification) {
            DateTime now = DateTime.now();
            userTemplate.setAttribute(INVITATION_SEND_DATE, Long.toString(now.getMillis()));
            userTemplate.setAttribute(INVITATION_EXPIRY_DATE, Long.toString(now.plusDays(tokenExpiryDays).getMillis()));
        }
        UserProvisioningService.ReservedProductAccess reservation = this.reserveProductAccess(this.productService.fetchProducts(productIds));
        UserWithAttributes user = this.addUser(userTemplate, useAtlassianId || sendNotification ? PasswordCredential.NONE : PasswordCredential.unencrypted((String)userFormEntity.getPassword().getValue()));
        if (useAtlassianId) {
            UserProfile inviterProfile = this.userManager.getRemoteUser();
            String inviterName = inviterProfile.getFullName();
            this.atlassianIdService.invite(inviterName, userFormEntity.getEmail(), personalNote, continueUrl, tokenExpiryDays, userFormEntity.getDisplayName());
        } else if (sendNotification) {
            try {
                this.sendEmailService.sendCreateUserPasswordEmail((User)user, tokenExpiryDays, emailTemplateName);
            }
            catch (AddressException e) {
                throw new InvalidEmailAddressException((Throwable)e);
            }
            catch (MailSendException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        reservation.apply(ImmutableSet.of((Object)user.getName()));
        Link userLink = LinkUriHelper.buildUserLink(baseURI, user.getName());
        return EntityTranslator.toUserEntity((User)user, userLink);
    }

    public void removeAIDFromUser(String userName) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        this.directoryManager.removeUserAttributes(this.getDirectoryId(), userName, "atlassianid.openid.identity");
    }

    private Option<String> getAIDFromUser(String userName) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        UserWithAttributes user = this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), userName);
        Set possibleValues = user.getValues("atlassianid.openid.identity");
        if (possibleValues == null || possibleValues.isEmpty()) {
            return Option.none();
        }
        return Option.some(possibleValues.iterator().next());
    }

    public void updateUserActive(String userName, URI baseURI, boolean active) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, InvalidUserException, DirectoryPermissionException, UserModificationNotAllowedException {
        Predicate<Product> licenseExceededOnActivationPredicate;
        List<Product> products;
        Iterable licenseExceededErrors;
        if (this.userAndGroupCheckService.isCurrentUser(userName)) {
            throw new UserModificationNotAllowedException(new DefaultMessage("usermanagement.users.deactivate.self.error", new Serializable[0]));
        }
        Option<Message> modificationAllowed = this.userAndGroupCheckService.canCurrentUserModifyUserData(userName);
        if (modificationAllowed.isDefined()) {
            throw new UserModificationNotAllowedException((Message)modificationAllowed.get());
        }
        if (active && !Iterables.isEmpty((Iterable)(licenseExceededErrors = Iterables.filter(products = this.productService.fetchProducts(), licenseExceededOnActivationPredicate = new LicenceExceedOnActivationPredicateFactory(this.userProvisioningService, userName, this.userAndGroupService.getGroupsForUser(userName)).buildActivationLicenceCheckPredicate())))) {
            throw new OperationFailedException(this.convertActivationLicenceExceededToI18nString(userName, licenseExceededErrors));
        }
        UserEntity userEntity = this.userAndGroupService.getUserEntity(userName, baseURI, false);
        UserTemplateWithAttributes user = (UserTemplateWithAttributes)EntityTranslator.fromUserEntity(userEntity);
        user.setActive(active);
        user.setDirectoryId(this.getDirectoryId());
        this.directoryManager.updateUser(this.getDirectoryId(), (UserTemplate)user);
    }

    public Either<ConflictingConfiguration, UserEntity> revokeProductAccess(String userName, URI baseURI, ProductId productToRevoke) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        UserEntity userEntity = this.userAndGroupService.getUserEntity(userName, baseURI, false);
        List<Product> products = this.productService.fetchProducts();
        Option<Object> targetProduct = Option.none();
        for (Product product : products) {
            if (!product.getProductId().equals(productToRevoke)) continue;
            targetProduct = Option.some(product);
        }
        if (targetProduct.isDefined()) {
            ImmutableMap toUpdate = ImmutableMap.of(targetProduct.get(), (Object)((Object)AccessLevel.NONE));
            Either<ConflictingConfiguration, Set<String>> result = this.userProvisioningService.updateAccessLevel(userName, (Map<Product, AccessLevel>)toUpdate, true, products);
            return result.right().map(Functions.constant((Object)userEntity));
        }
        return Either.right(userEntity);
    }

    public UserEntity updateUser(UserEntity userEntity, URI baseURI, boolean expandAttributes) throws UserNotFoundException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException, EmailAlreadyExistsException {
        boolean updateEmail;
        String name = userEntity.getName();
        Option<Message> modificationAllowed = this.userAndGroupCheckService.canCurrentUserModifyUserData(name);
        if (modificationAllowed.isDefined()) {
            throw new UserModificationNotAllowedException((Message)modificationAllowed.get());
        }
        User storedUser = this.directoryManager.findUserByName(this.getDirectoryId(), name);
        String newEmail = userEntity.getEmail();
        String storedEmail = storedUser.getEmailAddress();
        boolean bl = updateEmail = storedEmail == null || !storedEmail.equalsIgnoreCase(newEmail);
        if (updateEmail && this.emailExists(newEmail)) {
            throw new EmailAlreadyExistsException(newEmail);
        }
        UserTemplateWithAttributes user = (UserTemplateWithAttributes)EntityTranslator.fromUserEntity(userEntity);
        user.setDirectoryId(this.getDirectoryId());
        user.setActive(storedUser.isActive());
        this.directoryManager.updateUser(this.getDirectoryId(), (UserTemplate)user);
        return this.userAndGroupService.getUserEntity(name, baseURI, expandAttributes);
    }

    public void renameUser(String oldName, UserFormEntity userFormEntity) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, InvalidUserException, OperationFailedException, UserAlreadyExistsException {
        if (this.userAndGroupCheckService.canCurrentUserModifyUserData(oldName).isDefined()) {
            throw new UserModificationNotAllowedException(new DefaultMessage("usermanagement.error.modifysysadmin.user", new Serializable[0]));
        }
        UserWithAttributes user = this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), oldName);
        if (ACTIVATED_ATTRIBUTE_VALUE.equals(user.getValue(AGNI_GAPPS_USER_STATE_ATTRIBUTE_KEY))) {
            throw new UserModificationNotAllowedException(new DefaultMessage("usermanagement.warning.rename.googleapps", new Serializable[]{user.getDisplayName()}));
        }
        String newName = userFormEntity.getName();
        this.directoryManager.renameUser(this.getDirectoryId(), oldName, newName);
        try {
            this.renameBambooUser(oldName, newName);
        }
        catch (OperationFailedException e) {
            this.directoryManager.renameUser(this.getDirectoryId(), newName, oldName);
            throw e;
        }
    }

    @VisibleForTesting
    void renameBambooUser(final String oldUsername, final String newUsername) throws OperationFailedException {
        String url = UriBuilder.fromPath("/rest/admin/latest/user").queryParam("externalRename", true).build().toString();
        for (final ReadOnlyApplicationLink link : this.applicationLinkService.getApplicationLinks()) {
            if (!link.getType().getI18nKey().equals("applinks.bamboo")) continue;
            try {
                Option error = (Option)((ApplicationLinkRequest)((ApplicationLinkRequest)link.createAuthenticatedRequestFactory().createRequest(Request.MethodType.POST, url).setHeader("Content-Type", "application/json")).setEntity((Object)new BambooRenameEntity(newUsername, oldUsername))).executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, Option<String>>(){

                    public Option<String> handle(Response response) throws ResponseException {
                        if (response.isSuccessful()) {
                            return Option.none();
                        }
                        logger.error("Error renaming a user in Bamboo {}: {} {}", new Object[]{link.getName(), response.getStatusCode(), response.getStatusText()});
                        return Option.some(UserController.this.i18nResolver.getText("usermanagement.users.error.bamboo.rename", new Serializable[]{oldUsername, newUsername}));
                    }
                });
                if (!error.isDefined()) continue;
                throw new OperationFailedException((String)error.get());
            }
            catch (ResponseException e) {
                logger.error("Response error obtained while trying to rename a user in Bamboo.", (Throwable)e);
                throw new OperationFailedException(this.i18nResolver.getText("usermanagement.users.error.bamboo.rename", new Serializable[]{oldUsername, newUsername}));
            }
            catch (CredentialsRequiredException e) {
                logger.error("Invalid credentials to rename a user in Bamboo.", (Throwable)e);
                throw new OperationFailedException(this.i18nResolver.getText("usermanagement.users.error.bamboo.rename", new Serializable[]{oldUsername, newUsername}));
            }
        }
    }

    public Iterable<UserEntity> findUsersByName(@Nullable String nameFilter, int startIndex, int maxResults, URI baseUri, List<String> userFilters, List<Boolean> activeFilters, List<String> newUserNamesToPrepend) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        List<SearchRestriction> restrictions = this.applyFilters(nameFilter, userFilters, activeFilters);
        NullRestriction combinedRestriction = restrictions.isEmpty() ? NullRestrictionImpl.INSTANCE : Combine.allOf(restrictions);
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)combinedRestriction).startingAt(startIndex).returningAtMost(maxResults);
        ImmutableList<User> users = UserController.explicitlyOrderUsersByUsername(newUserNamesToPrepend, this.directoryManager.searchUsers(this.getDirectoryId(), query));
        Directory directory = this.directoryManager.findDirectoryById(this.getDirectoryId());
        return Lists.transform(this.getUserWithAttributes((List<User>)users), (Function)UserController.toUserEntity(directory, baseUri));
    }

    @VisibleForTesting
    protected List<SearchRestriction> applyFilters(@Nullable String nameFilter, List<String> userFilters, List<Boolean> activeFilters) {
        ArrayList orRestrictions;
        ArrayList userRestrictions = Lists.newArrayList();
        if (StringUtils.isNotEmpty(nameFilter)) {
            userRestrictions.add(Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)nameFilter), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)nameFilter), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)nameFilter)}));
        }
        if (userFilters != null && !userFilters.isEmpty()) {
            orRestrictions = Lists.newArrayList();
            if (userFilters.contains(ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)) {
                orRestrictions.add(Restriction.on((Property)PropertyUtils.ofTypeString((String)ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)).exactlyMatching((Object)"true"));
            }
            if (userFilters.contains(USERS_FILTER)) {
                orRestrictions.add(Restriction.on((Property)PropertyUtils.ofTypeString((String)ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)).isNull());
            }
            userRestrictions.add(Combine.anyOf((Collection)orRestrictions));
        }
        if (activeFilters != null && !activeFilters.isEmpty()) {
            orRestrictions = Lists.newArrayList();
            for (Boolean activeState : activeFilters) {
                orRestrictions.add(Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)activeState));
            }
            userRestrictions.add(Combine.anyOf((Collection)orRestrictions));
        }
        return userRestrictions;
    }

    private List<UserWithAttributes> getUserWithAttributes(List<User> users) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        ImmutableList.Builder usersWithAttributesBuilder = ImmutableList.builder();
        for (User user : users) {
            usersWithAttributesBuilder.add((Object)this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), user.getName()));
        }
        return usersWithAttributesBuilder.build();
    }

    public Iterable<UserEntity> findUsersByGroup(String groupName, int startIndex, int maxResults, List<String> newUserNamesToPrepend, URI baseUri) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        ImmutableList<User> users = UserController.explicitlyOrderUsersByUsername(newUserNamesToPrepend, this.directoryManager.searchDirectGroupRelationships(this.getDirectoryId(), query));
        Directory directory = this.directoryManager.findDirectoryById(this.getDirectoryId());
        return Lists.transform(this.getUserWithAttributes((List<User>)users), (Function)UserController.toUserEntityWithAccessControl(directory, baseUri, this.userAndGroupCheckService, groupName, this.i18nResolver));
    }

    public RestGroupEntityList getDirectGroups(final String userName, int maxResults, int startIndex, List<String> newGroupNamesToPrepend, final URI baseUri) throws DirectoryNotFoundException, OperationFailedException {
        final boolean cannotModifyUser = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName).isDefined();
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.user(), (String)userName);
        List groups = this.directoryManager.searchNestedGroupRelationships(this.getDirectoryId(), query);
        try {
            List<Group> orderedGroups = this.explictlyPrependGroupsByGroupname(newGroupNamesToPrepend, groups);
            final List<Product> products = this.productService.fetchProducts();
            return new RestGroupEntityList(Lists.transform(orderedGroups, (Function)new Function<Group, RestGroupEntity>(){

                public RestGroupEntity apply(Group group) {
                    return new GroupController.GroupToRestGroup(baseUri, UserController.this.userAndGroupCheckService, UserController.this.i18nResolver, products, cannotModifyUser, UserController.this.userAndGroupCheckService.isCurrentUser(userName)).apply(group);
                }
            }));
        }
        catch (GroupNotFoundException e) {
            throw new OperationFailedException("Group not found during ordering", (Throwable)e);
        }
    }

    public RestGroupEntity getDirectGroup(String userName, String groupName, URI baseUri) throws DirectoryNotFoundException, OperationFailedException, MembershipNotFoundException {
        boolean isMember = this.directoryManager.isUserNestedGroupMember(this.getDirectoryId(), userName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(userName, groupName);
        }
        boolean isCurrentUser = this.userAndGroupCheckService.isCurrentUser(userName);
        boolean cannotModifyUserAccess = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName).isDefined();
        return new GroupController.StringToRestGroup(baseUri, this.userAndGroupCheckService, this.i18nResolver, this.productService.fetchProducts(), isCurrentUser, cannotModifyUserAccess).apply(groupName);
    }

    private static UserEntityTransformer toUserEntity(Directory directory, URI baseUri) {
        return new UserEntityTransformer(directory, baseUri);
    }

    private static UserEntityWithAccessControlTransformer toUserEntityWithAccessControl(Directory directory, URI baseUri, UserAndGroupCheckService userAndGroupCheckService, String groupName, I18nResolver i18nResolver) {
        return new UserEntityWithAccessControlTransformer(directory, baseUri, userAndGroupCheckService, groupName, i18nResolver);
    }

    public void sendForgotPasswordEmail(String username) throws OperationFailedException, InvalidEmailAddressException, DirectoryNotFoundException, UserNotFoundException, MailServerConfigurationException, InactiveAccountException {
        User user = this.directoryManager.findUserByName(this.getDirectoryId(), username);
        if (!user.isActive()) {
            throw new InactiveAccountException(username);
        }
        try {
            this.sendEmailService.sendForgotPasswordEmail(user);
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException((Throwable)e);
        }
        catch (MailSendException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void sendForgotUsernameEmail(String email) throws OperationFailedException, InvalidEmailAddressException, DirectoryNotFoundException, MailServerConfigurationException {
        EntityQuery<User> query = this.buildUserQueryByEmail(email);
        List users = this.directoryManager.searchUsers(this.getDirectoryId(), query);
        try {
            this.sendEmailService.sendForgotUsernameEmail(email, users);
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException((Throwable)e);
        }
        catch (MailSendException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @VisibleForTesting
    EntityQuery<User> buildUserQueryByEmail(String email) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)email)).returningAtMost(-1);
    }

    public void updateUserPassword(String username, String password) throws InvalidCredentialException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException {
        Option<Message> modificationAllowed = this.userAndGroupCheckService.canCurrentUserModifyUserData(username);
        if (modificationAllowed.isDefined()) {
            throw new UserModificationNotAllowedException((Message)modificationAllowed.get());
        }
        this.directoryManager.updateUserCredential(this.getDirectoryId(), username, PasswordCredential.unencrypted((String)password));
    }

    public boolean canResetUserPassword(long directoryId, String username, String token) {
        return this.forgottenLoginManager.isValidResetToken(directoryId, username, token);
    }

    public void changeUsersPassword(String username, String oldPassword, String newPassword) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, DirectoryNotFoundException, ExpiredCredentialException, UserNotFoundException, InvalidCredentialException, DirectoryPermissionException {
        this.directoryManager.authenticateUser(this.getDirectoryId(), username, PasswordCredential.unencrypted((String)oldPassword));
        this.directoryManager.updateUserCredential(this.getDirectoryId(), username, PasswordCredential.unencrypted((String)newPassword));
    }

    public void resetUserPassword(long directoryId, String username, String token, String password) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, InvalidCredentialException, InvalidResetPasswordTokenException, OperationFailedException {
        if (!this.forgottenLoginManager.isValidResetToken(directoryId, username, token)) {
            throw new InvalidResetPasswordTokenException("Invalid reset password token");
        }
        this.forgottenLoginManager.resetUserCredential(directoryId, username, PasswordCredential.unencrypted((String)password), token);
    }

    public BulkAppAccessOperationResult grantProductAccess(List<Product> allProducts, Collection<String> userNames, Set<Product> products, boolean bypassActiveChecks) throws DirectoryNotFoundException, OperationFailedException, NoDefaultGroupException, UserNotFoundException, GroupNotFoundException, MembershipChangeCausingLicenseException, ReadOnlyGroupException, DirectoryPermissionException {
        ImmutableMap<String, Either<Failure, GrantProductAccessResult>> result = ImmutableMapUtils.transformKey(this.userProvisioningService.grantProductAccess(allProducts, (Set<String>)ImmutableSet.copyOf(userNames), products, bypassActiveChecks, false), new Function<Product, String>(){

            public String apply(@Nullable Product input) {
                return input.getProductId().toString();
            }
        });
        ImmutableMap completed = ImmutableMapUtils.collectByValue(result, Eithers.rightMapper());
        ImmutableMap failedResults = ImmutableMapUtils.collectByValue(result, Eithers.leftMapper());
        ImmutableMap<String, LicenseExceeded> licenseExceeded = ImmutableMapUtils.collectByValue(failedResults, com.atlassian.fugue.Functions.isInstanceOf(LicenseExceeded.class));
        ImmutableMap<String, String> aborted = ImmutableMapUtils.collectByValue(failedResults, new Function<Failure, Option<String>>(){

            public Option<String> apply(@Nullable Failure input) {
                if (input instanceof LicenseExceeded) {
                    return Option.none();
                }
                if (input instanceof ProductAccessError) {
                    return Option.some(((ProductAccessError)input).getReason());
                }
                return Option.some(UserController.this.i18nResolver.getText("usermanagement.apps.users.granted.access.to.product.error"));
            }
        });
        return new BulkAppAccessOperationResult((Map<String, GrantProductAccessResult>)completed, (Map<String, LicenseExceeded>)licenseExceeded, (Map<String, String>)aborted);
    }

    public BulkAppAccessOperationResult grantProductAccess(List<Product> allProducts, String userLookupId, Set<Product> requiredProducts) throws DirectoryNotFoundException, OperationFailedException, NoDefaultGroupException, UserNotFoundException, MembershipChangeCausingLicenseException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException {
        Collection<Object> users = new HashSet();
        if (userLookupId.equals(ALL_USERS)) {
            users = this.userAndGroupService.getAllUsersValidForProductAccess();
        } else {
            Product sourceProduct;
            Option<Product> optionalProduct = ProductUtils.findProduct(allProducts, new ProductId(userLookupId));
            if (optionalProduct.isDefined() && (sourceProduct = (Product)optionalProduct.get()).hasProductConfig().booleanValue()) {
                users = this.userProvisioningService.findUsernamesGrantedAccessToProduct(sourceProduct);
            }
        }
        boolean skipActiveCheck = true;
        return this.grantProductAccess(allProducts, users, requiredProducts, true);
    }

    public Set<String> inviteUser(Set<UserInvite> invites, Option<Set<ProductId>> productIds, int tokenExpiryDays, Option<String> personalNote, String continueUrl) throws LicenseExceededException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException, InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, DirectoryPermissionException, MailServerConfigurationException, MailSendException, AddressException {
        Option<Iterable<Product>> products = productIds.map(new Function<Iterable<ProductId>, Iterable<Product>>(){

            public Iterable<Product> apply(@Nullable Iterable<ProductId> productIds) {
                return UserController.this.productService.fetchProducts(productIds);
            }
        });
        UserProvisioningService.ReservedProductAccess reservation = this.reserveProductAccess(invites.size(), products);
        UserProfile inviterProfile = this.userManager.getRemoteUser();
        String inviterName = inviterProfile.getFullName();
        User inviter = this.directoryManager.findUserByName(this.getDirectoryId(), inviterProfile.getUsername());
        boolean useAtlassianId = this.darkFeatureManager.isFeatureEnabledForAllUsers(AID_INTEGRATION_FEATURE_KEY);
        HashSet usersAdded = Sets.newHashSet();
        for (UserInvite invite : invites) {
            User newlyCreatedUser;
            String emailAddress = invite.email();
            Option<String> displayName = invite.displayName();
            if (this.emailExists(emailAddress)) {
                newlyCreatedUser = null;
            } else {
                String username = this.generateUsername(emailAddress);
                newlyCreatedUser = this.createUserToBeAdded(username, displayName, emailAddress, tokenExpiryDays);
                usersAdded.add(username);
            }
            if (useAtlassianId) {
                String note = personalNote.getOrNull();
                this.atlassianIdService.invite(inviterName, emailAddress, StringUtils.trimToNull(note), continueUrl, tokenExpiryDays, null);
                continue;
            }
            if (newlyCreatedUser != null) {
                this.sendEmailService.sendCreateUserPasswordEmail(newlyCreatedUser, tokenExpiryDays);
                continue;
            }
            this.sendEmailService.sendInviteUserEmailExistingUser(inviter, emailAddress);
        }
        reservation.apply(usersAdded);
        return usersAdded;
    }

    private User createUserToBeAdded(String username, Option<String> displayName, String emailAddress, int tokenExpiryDays) throws DirectoryPermissionException, DirectoryNotFoundException, InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException, UserNotFoundException {
        UserTemplateWithAttributes userTemplate = UserController.newUserTemplate(username, emailAddress, this.getDirectoryId(), displayName);
        DateTime now = DateTime.now();
        userTemplate.setAttribute(INVITATION_SEND_DATE, Long.toString(now.getMillis()));
        userTemplate.setAttribute(INVITATION_EXPIRY_DATE, Long.toString(now.plusDays(tokenExpiryDays).getMillis()));
        return this.addUser(userTemplate, PasswordCredential.NONE);
    }

    private UserWithAttributes addUser(UserTemplateWithAttributes userTemplate, PasswordCredential passwordCredential) throws DirectoryPermissionException, DirectoryNotFoundException, InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException {
        return this.directoryManager.addUser(this.getDirectoryId(), userTemplate, passwordCredential);
    }

    private Map<Product, Integer> getAvailableSeatsForDefaultProducts() {
        List<Product> products = this.productService.fetchProducts();
        return this.getAvailableSeatsForProducts(this.userProvisioningService.getDefaultProducts(products));
    }

    private Map<Product, Integer> getAvailableSeatsForProducts(Iterable<Product> products) {
        ImmutableMap<Product, Option<Integer>> seats = ImmutableMapUtils.toMap(products, UserProvisioningServiceFunctions.calculateAvailableSeatsForProduct(this.userProvisioningService));
        return ImmutableMapUtils.collectByValue(seats, Functions.identity());
    }

    private boolean emailExists(String emailAddress) throws DirectoryNotFoundException, OperationFailedException {
        return !this.directoryManager.searchUsers(this.getDirectoryId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)emailAddress)).returningAtMost(1)).isEmpty();
    }

    public Option<ExpirableUserToken> getInvitation(String token) {
        return this.invitationService.getInvitation(token);
    }

    public UserEntity addUserWithToken(UserEntity inputUserEntity, URI baseURI, String token, String serverName) throws UserAlreadyExistsException, InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, LicenseExceededException, InvalidInvitationException, MailServerConfigurationException, MailSendException, AddressException, UserNotFoundException, EmailAlreadyExistsException {
        Option<ExpirableUserToken> maybeInvitation = this.invitationService.getInvitation(token);
        if (maybeInvitation.isEmpty()) {
            throw new InvalidInvitationException();
        }
        inputUserEntity.setEmail(((ExpirableUserToken)maybeInvitation.get()).getEmailAddress());
        UserEntity outputUserEntity = this.addUserWithDefaultProductAccess(inputUserEntity, baseURI, false);
        this.invitationService.removeToken(token);
        if (this.signupSettingsService.isEmailSentOnSignUp()) {
            User user = this.directoryManager.findUserByName(this.getDirectoryId(), outputUserEntity.getName());
            Map<String, Integer> licenses = UserController.transformKeys(this.getAvailableSeatsForDefaultProducts(), this.PRODUCT_TO_NAME);
            for (User admin : this.getDirectUsersOfGroup(CROSS_PRODUCT_ADMINS)) {
                this.sendEmailService.sendSignupNotificationEmail(admin.getEmailAddress(), user, licenses, serverName);
            }
        }
        return outputUserEntity;
    }

    private static UserTemplateWithAttributes newUserTemplate(UserEntity userEntity, long directoryId) {
        return UserTemplateBuilder.from(userEntity).withDirectoryId(directoryId).withActive(true).build();
    }

    private static UserTemplateWithAttributes newUserTemplate(String name, String emailAddress, long directoryId, Option<String> displayName) {
        return UserTemplateBuilder.withName(name).withDisplayName(displayName.getOrNull()).withEmailAddress(emailAddress).withDirectoryId(directoryId).withActive(true).build();
    }

    private static <K, V> Map<K, Set<String>> createAttributesMap(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, Collections.singleton(String.valueOf(v1)), k2, Collections.singleton(String.valueOf(v2)));
    }

    private static <K1, K2, V> Map<K2, V> transformKeys(Map<K1, V> fromMap, Function<? super K1, K2> function) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K1, V> entry : fromMap.entrySet()) {
            builder.put(function.apply(entry.getKey()), entry.getValue());
        }
        return builder.build();
    }

    public void selfInvite(PublicSignUpFormEntity publicSignUpFormEntity) throws SignupNotEnabledException, EmailNotAllowedException, DirectoryNotFoundException, OperationFailedException, AddressException, MailServerConfigurationException, MailSendException, UserNotFoundException, ObjectAlreadyExistsException, EmailAlreadyExistsException {
        if (!this.signupSettingsService.isSignupEnabled()) {
            throw new SignupNotEnabledException();
        }
        String email = publicSignUpFormEntity.getEmail();
        if (!this.signupSettingsService.isEmailAllowed(email)) {
            throw new EmailNotAllowedException();
        }
        if (this.emailExists(email)) {
            throw new EmailAlreadyExistsException(email);
        }
        String token = this.invitationService.createAndStoreInviteToken(email, SELF_INVITE_EXPIRY_SECONDS);
        this.sendEmailService.sendSignUpEmail(email, token);
    }

    private List<User> getDirectUsersOfGroup(String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.searchDirectGroupRelationships(this.getDirectoryId(), QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
    }

    public UserEntity addUserWithDefaultProductAccess(UserEntity userEntity, URI baseURI, boolean expandAttributes) throws UserAlreadyExistsException, InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, LicenseExceededException, EmailAlreadyExistsException {
        PasswordCredential credential;
        String email = userEntity.getEmail();
        if (this.emailExists(email)) {
            throw new EmailAlreadyExistsException(email);
        }
        UserProvisioningService.ReservedProductAccess reservation = this.reserveDefaultProductAccessAnonymously();
        PasswordCredential passwordCredential = credential = userEntity.getPassword() != null && userEntity.getPassword().getValue() != null ? PasswordCredential.unencrypted((String)userEntity.getPassword().getValue()) : PasswordCredential.NONE;
        if (userEntity.getName() == null) {
            userEntity.setName(this.generateUsername(userEntity.getEmail(), userEntity.getDisplayName()));
        }
        UserTemplateWithAttributes userTemplate = UserController.newUserTemplate(userEntity, this.getDirectoryId());
        this.addUser(userTemplate, credential);
        reservation.apply(ImmutableSet.of((Object)userEntity.getName()));
        try {
            return this.userAndGroupService.getUserEntity(userEntity.getName(), baseURI, expandAttributes);
        }
        catch (UserNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private String generateUsername(String email) throws OperationFailedException {
        return this.generateUsername(email, null);
    }

    private String generateUsername(String email, String displayName) throws OperationFailedException {
        Optional username = Iterables.tryFind(UserController.generateUsernames(email, displayName), (Predicate)Predicates.not(this.USERNAME_EXISTS_PREDICATE));
        if (!username.isPresent()) {
            throw new OperationFailedException("Cannot generate a username for the new user");
        }
        return (String)username.get();
    }

    @VisibleForTesting
    static Iterable<String> generateUsernames(String email, String displayName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String emailLocalPart = "";
        if (email != null && email.contains("@") && StringUtils.isNotBlank(emailLocalPart = email.split("@")[0])) {
            builder.add((Object)emailLocalPart);
        }
        String normalisedDisplayName = "";
        if (displayName != null && StringUtils.isNotBlank(normalisedDisplayName = displayName.replaceAll("\\W", "").toLowerCase())) {
            builder.add((Object)normalisedDisplayName);
        }
        String prefix = StringUtils.isNotBlank(emailLocalPart) ? emailLocalPart : (StringUtils.isNotBlank(normalisedDisplayName) ? normalisedDisplayName : "user");
        for (int i = 1; i <= 20; ++i) {
            builder.add((Object)(prefix + i));
        }
        builder.add((Object)(prefix + (USERNAME_RANDOM_GENERATOR.nextInt(80) + 20 + 1)));
        builder.add((Object)(prefix + (USERNAME_RANDOM_GENERATOR.nextInt(80) + 20 + 1)));
        builder.add((Object)(prefix + (USERNAME_RANDOM_GENERATOR.nextInt(80) + 20 + 1)));
        builder.add((Object)(prefix + USERNAME_RANDOM_GENERATOR.nextInt(Integer.MAX_VALUE)));
        builder.add((Object)(prefix + USERNAME_RANDOM_GENERATOR.nextInt(Integer.MAX_VALUE)));
        builder.add((Object)(prefix + USERNAME_RANDOM_GENERATOR.nextInt(Integer.MAX_VALUE)));
        return builder.build();
    }

    public void grantDefaultProductAccess(String username) throws LicenseExceededException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, NoDefaultGroupException, ReadOnlyGroupException, MembershipChangeCausingLicenseException, GroupNotFoundException, DirectoryPermissionException {
        List<Product> allProducts = this.productService.fetchProducts();
        this.userAndGroupService.getUser(username);
        FailureUtils.handleMaybeFailures(this.userProvisioningService.grantProductAccessAnonymously(allProducts, (Set<String>)ImmutableSet.of((Object)username), this.userProvisioningService.getDefaultProducts(allProducts)));
    }

    private UserProvisioningService.ReservedProductAccess reserveProductAccess(Iterable<Product> products) throws LicenseExceededException {
        return this.reserveProductAccess(1, Option.some(products));
    }

    private UserProvisioningService.ReservedProductAccess reserveProductAccess(int needed, Option<Iterable<Product>> products) throws LicenseExceededException {
        Set<Product> productOrDefaults;
        if (products.isEmpty()) {
            List<Product> allProducts = this.productService.fetchProducts();
            productOrDefaults = this.userProvisioningService.getDefaultProducts(allProducts);
        } else {
            productOrDefaults = (Set<Product>)products.get();
        }
        Either<Map<Product, Failure>, UserProvisioningService.ReservedProductAccess> failureOrReservation = this.userProvisioningService.reserveProductAccess(needed, productOrDefaults);
        return FailureUtils.handleMaybeFailures(failureOrReservation);
    }

    private UserProvisioningService.ReservedProductAccess reserveDefaultProductAccessAnonymously() throws LicenseExceededException {
        List<Product> products = this.productService.fetchProducts();
        Set<Product> defaultProducts = this.userProvisioningService.getDefaultProducts(products);
        Either<Map<Product, Failure>, UserProvisioningService.ReservedProductAccess> failureOrReservation = this.userProvisioningService.reserveProductAccessAnonymously(1, defaultProducts);
        return FailureUtils.handleMaybeFailures(failureOrReservation);
    }

    private String convertActivationLicenceExceededToI18nString(String username, Iterable<Product> products) {
        int size = Iterables.size(products);
        if (size == 0) {
            throw new IllegalArgumentException("No products required converting");
        }
        if (size == 1) {
            return this.i18nResolver.getText("usermanagement.users.activate.error.over.licence.count.message.one", new Serializable[]{username, ((Product)Iterables.get(products, (int)0)).getProductName()});
        }
        if (size == 2) {
            return this.i18nResolver.getText("usermanagement.users.activate.error.over.licence.count.message.two", new Serializable[]{username, ((Product)Iterables.get(products, (int)0)).getProductName(), ((Product)Iterables.get(products, (int)1)).getProductName()});
        }
        return this.i18nResolver.getText("usermanagement.users.activate.error.over.licence.count.message.many", new Serializable[]{username});
    }

    @VisibleForTesting
    static ImmutableList<User> explicitlyOrderUsersByUsername(List<String> usernames, Iterable<User> users) {
        return UserController.explicitlyOrder(usernames, new Function<User, String>(){

            public String apply(User user) {
                return user.getName();
            }
        }, users);
    }

    @VisibleForTesting
    List<Group> explictlyPrependGroupsByGroupname(List<String> orderedGroupNames, List<Group> initialGroups) throws DirectoryNotFoundException, OperationFailedException, GroupNotFoundException {
        if (orderedGroupNames == null || orderedGroupNames.isEmpty()) {
            return initialGroups;
        }
        ImmutableList.Builder priorityGroups = ImmutableList.builder();
        for (String groupName : orderedGroupNames) {
            priorityGroups.add((Object)this.directoryManager.findGroupByName(this.getDirectoryId(), groupName));
        }
        ImmutableList priorityGroupsList = priorityGroups.build();
        ImmutableList allGroupsInDesiredOrder = ImmutableList.builder().addAll((Iterable)priorityGroupsList).addAll(Iterables.filter(initialGroups, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)priorityGroupsList)))).build();
        return ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)allGroupsInDesiredOrder, (int)initialGroups.size()));
    }

    private static <T, F, E extends F> ImmutableList<E> explicitlyOrder(List<T> valuesInOrder, Function<F, ? extends T> function, Iterable<E> elements) {
        return new ExplicitOrdering<T>(valuesInOrder).onResultOf(function).immutableSortedCopy(elements);
    }

    private static class UserEntityWithAccessControlTransformer
    implements Function<UserWithAttributes, UserEntity> {
        private final Directory directory;
        private final URI baseUri;
        private final UserAndGroupCheckService userAndGroupCheckService;
        private final String groupName;
        private final I18nResolver i18nResolver;

        private UserEntityWithAccessControlTransformer(Directory directory, URI baseUri, UserAndGroupCheckService userAndGroupCheckService, String groupName, I18nResolver i18nResolver) {
            this.directory = directory;
            this.baseUri = baseUri;
            this.userAndGroupCheckService = userAndGroupCheckService;
            this.groupName = groupName;
            this.i18nResolver = i18nResolver;
        }

        public UserEntity apply(UserWithAttributes user) {
            String username = user.getName();
            Link userLink = LinkUriHelper.buildUserLink(this.baseUri, username);
            UserEntity userEntity = EntityTranslator.toUserEntity((User)user, (Attributes)user, userLink);
            userEntity.setDirectoryName(this.directory.getName());
            Option<Message> accessMessage = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(username);
            Option<Message> dataMessage = this.userAndGroupCheckService.canCurrentUserModifyUserData(username);
            String disabledMessage = MessageHelper.getDisabledMessage(accessMessage, dataMessage, this.i18nResolver);
            LozengeEntity lozenge = this.userAndGroupCheckService.getUserLozenge(userEntity).getOrNull();
            return new ListViewUser(userEntity, null, this.unableToModifyAccess(username, accessMessage), this.unableToEdit(username), disabledMessage, lozenge, this.userAndGroupCheckService.isCurrentUser(username));
        }

        private boolean unableToModifyAccess(String username, Option<Message> accessMessage) {
            return accessMessage.isDefined() || this.userAndGroupCheckService.isCurrentUser(username) && this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(this.groupName).isDefined();
        }

        private boolean unableToEdit(String username) {
            return this.userAndGroupCheckService.canCurrentUserModifyUserData(username).isDefined();
        }
    }

    private static class UserEntityTransformer
    implements Function<UserWithAttributes, UserEntity> {
        private final Directory directory;
        private final URI baseUri;

        private UserEntityTransformer(Directory directory, URI baseUri) {
            this.directory = directory;
            this.baseUri = baseUri;
        }

        public UserEntity apply(UserWithAttributes user) {
            Link userLink = LinkUriHelper.buildUserLink(this.baseUri, user.getName());
            UserEntity userEntity = EntityTranslator.toUserEntity((User)user, (Attributes)user, userLink);
            userEntity.setDirectoryName(this.directory.getName());
            return userEntity;
        }
    }
}

