/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.RestGroupEntity;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.ProductService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.crowd.plugin.usermanagement.service.products.ProductConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ProductAccessError;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.fugue.Either;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.usermanagement.client.AccessLevel;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class GroupController
extends BaseController {
    private final DirectoryManager directoryManager;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final I18nResolver i18nResolver;
    private final ProductService productService;

    public GroupController(DirectoryManager directoryManager, DirectoryLocator directoryLocator, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver, ProductService productService) {
        super(directoryLocator, i18nResolver);
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.i18nResolver = i18nResolver;
        this.productService = productService;
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
    }

    public RestGroupEntity getGroup(String groupName, URI baseUri) throws DirectoryNotFoundException, GroupNotFoundException, OperationFailedException {
        Preconditions.checkNotNull((Object)groupName);
        Group group = this.getGroupByName(groupName);
        return new GroupToRestGroup(baseUri, this.userAndGroupCheckService, this.i18nResolver, this.productService.fetchProducts(), false, true).apply(group);
    }

    private Group getGroupByName(String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.findGroupByName(this.getDirectoryId(), groupName);
    }

    public Iterable<RestGroupEntity> findGroupsByName(@Nullable String nameFilter, int startIndex, int maxResults, URI baseUri) throws DirectoryNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with(this.groupRestriction(nameFilter)).startingAt(startIndex).returningAtMost(maxResults);
        List groups = this.directoryManager.searchGroups(this.getDirectoryId(), query);
        return Lists.transform((List)groups, (Function)GroupController.toRestGroupEntity(baseUri, this.userAndGroupCheckService, this.i18nResolver, this.productService.fetchProducts(), false, true));
    }

    public RestGroupEntity addGroup(GroupEntity group, URI baseURI) throws DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, InvalidGroupException {
        GroupTemplate groupTemplate = new GroupTemplate(group.getName(), this.getDirectoryId(), GroupType.GROUP);
        groupTemplate.setActive(group.isActive() == null ? true : group.isActive());
        groupTemplate.setDescription(group.getDescription());
        return RestGroupEntity.fromGroup(this.directoryManager.addGroup(this.getDirectoryId(), groupTemplate), baseURI);
    }

    public RestGroupEntity updateGroup(GroupEntity group, URI baseUri) throws InvalidGroupException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, ReadOnlyGroupException {
        GroupTemplate groupTemplate = new GroupTemplate(group.getName(), this.getDirectoryId(), GroupType.GROUP);
        groupTemplate.setDescription(group.getDescription());
        groupTemplate.setActive(group.isActive() == null ? true : group.isActive());
        return RestGroupEntity.fromGroup(this.directoryManager.updateGroup(this.getDirectoryId(), groupTemplate), baseUri);
    }

    private SearchRestriction groupRestriction(String name) {
        if (StringUtils.isEmpty(name)) {
            return NullRestrictionImpl.INSTANCE;
        }
        return Restriction.on((Property)GroupTermKeys.NAME).containing((Object)name);
    }

    private static RestGroupEntityTransformer toRestGroupEntity(URI baseUri, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver, List<Product> products, boolean cannotModifyUser, boolean isCurrentUser) {
        return new GroupToRestGroup(baseUri, userAndGroupCheckService, i18nResolver, products, cannotModifyUser, isCurrentUser);
    }

    public static String getProductsString(I18nResolver i18nResolver, List<Product> products) {
        ArrayList names = Lists.newArrayList((Iterable)Collections2.transform(products, (Function)new Function<Product, String>(){

            public String apply(Product product) {
                return product.getProductName();
            }
        }));
        String allButLast = Joiner.on((String)", ").join(Iterables.limit((Iterable)names, (int)Math.max(1, names.size() - 1)));
        if (names.size() > 1) {
            return allButLast + " " + i18nResolver.getText("usermanagement.generic.and") + " " + (String)names.get(names.size() - 1);
        }
        return allButLast;
    }

    public static abstract class RestGroupEntityTransformer<G>
    implements Function<G, RestGroupEntity> {
        protected final URI baseUri;
        protected final UserAndGroupCheckService userAndGroupCheckService;
        protected final I18nResolver i18nResolver;
        protected final List<Product> products;

        public RestGroupEntityTransformer(URI baseUri, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver, List<Product> products) {
            this.baseUri = baseUri;
            this.userAndGroupCheckService = userAndGroupCheckService;
            this.i18nResolver = i18nResolver;
            this.products = products;
        }

        protected abstract RestGroupEntity createBaseRestGroupEntity(G var1) throws CrowdException;

        public RestGroupEntity apply(G crowdGroup) {
            try {
                RestGroupEntity group = this.createBaseRestGroupEntity(crowdGroup);
                ArrayList<Product> defaults = new ArrayList<Product>();
                ArrayList<Product> access = new ArrayList<Product>();
                ArrayList<Product> admin = new ArrayList<Product>();
                ArrayList<Product> sysadmin = new ArrayList<Product>();
                for (Product product : this.products) {
                    Either<ProductAccessError, ProductConfig> maybeProductConfig = product.fetchProductConfig();
                    if (!maybeProductConfig.isRight()) continue;
                    ProductConfig config = (ProductConfig)maybeProductConfig.right().get();
                    if (config.getGroups(AccessLevel.SYSADMIN).contains(group.getName())) {
                        sysadmin.add(product);
                    }
                    if (config.getGroups(AccessLevel.ADMIN).contains(group.getName())) {
                        admin.add(product);
                    }
                    if (config.getDefaultGroups(AccessLevel.USE).contains(group.getName())) {
                        defaults.add(product);
                        continue;
                    }
                    if (!config.getGroups(AccessLevel.USE).contains(group.getName())) continue;
                    access.add(product);
                }
                if (!defaults.isEmpty()) {
                    group.addLozenge(new LozengeEntity(this.i18nResolver.getText("usermanagement.accessconfig.lozenge.default"), this.i18nResolver.getText("usermanagement.accessconfig.lozenge.default.desc", new Serializable[]{GroupController.getProductsString(this.i18nResolver, defaults)}), LozengeEntity.Type.DEFAULT));
                }
                if (!access.isEmpty()) {
                    group.addLozenge(new LozengeEntity(this.i18nResolver.getText("usermanagement.accessconfig.lozenge.access"), this.i18nResolver.getText("usermanagement.accessconfig.lozenge.access.desc", new Serializable[]{GroupController.getProductsString(this.i18nResolver, access)}), LozengeEntity.Type.ACCESS));
                }
                if (!admin.isEmpty()) {
                    group.addLozenge(new LozengeEntity(this.i18nResolver.getText("usermanagement.accessconfig.lozenge.admin"), this.i18nResolver.getText("usermanagement.accessconfig.lozenge.admin.desc", new Serializable[]{GroupController.getProductsString(this.i18nResolver, admin)}), LozengeEntity.Type.ADMIN));
                }
                return group;
            }
            catch (CrowdException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class GroupToRestGroup
    extends RestGroupEntityTransformer<Group> {
        private boolean cannotModifyUser;
        private boolean isCurrentUser;

        public GroupToRestGroup(URI baseUri, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver, List<Product> products, boolean cannotModifyUser, boolean isCurrentUser) {
            super(baseUri, userAndGroupCheckService, i18nResolver, products);
            this.cannotModifyUser = cannotModifyUser;
            this.isCurrentUser = isCurrentUser;
        }

        @Override
        protected RestGroupEntity createBaseRestGroupEntity(Group group) throws DirectoryNotFoundException, OperationFailedException {
            return RestGroupEntity.newRestGroupEntity(group.getName(), group.getDescription(), group.isActive(), this.userAndGroupCheckService.canCurrentUserModifyGroup(group.getName()).isDefined() || this.cannotModifyUser, this.isCurrentUser && this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(group.getName()).isDefined(), this.baseUri);
        }
    }

    public static class StringToRestGroup
    extends RestGroupEntityTransformer<String> {
        private boolean isCurrentUser;
        private boolean cannotModifyUser;

        public StringToRestGroup(URI baseUri, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver, List<Product> products, boolean isCurrentUser, boolean cannotModifyUser) {
            super(baseUri, userAndGroupCheckService, i18nResolver, products);
            this.isCurrentUser = isCurrentUser;
            this.cannotModifyUser = cannotModifyUser;
        }

        @Override
        protected RestGroupEntity createBaseRestGroupEntity(String group) {
            boolean isUnmodifiable = this.userAndGroupCheckService.canCurrentUserModifyGroup(group).isDefined() || this.cannotModifyUser;
            boolean isLastAdminGroup = this.isCurrentUser && this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(group).isDefined();
            return RestGroupEntity.newMinimalRestGroupEntity(group, this.baseUri, isUnmodifiable, isLastAdminGroup);
        }
    }
}

