/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.products.Product;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.usermanagement.client.AccessLevel;
import com.atlassian.usermanagement.client.util.ImmutableMapUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class BaseController {
    protected final DirectoryLocator directoryLocator;
    protected final I18nResolver i18nResolver;

    public BaseController(DirectoryLocator directoryLocator, I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.directoryLocator = (DirectoryLocator)Preconditions.checkNotNull((Object)directoryLocator);
    }

    protected long getDirectoryId() {
        return this.directoryLocator.getDirectoryId();
    }

    protected Map<String, AccessLevel> translateAccessLevelRepresentation(Map<Product, AccessLevel> accessLevel) {
        return ImmutableMapUtils.transformKey(accessLevel, new Function<Product, String>(){

            public String apply(@Nullable Product input) {
                return input.getProductId().toString();
            }
        });
    }
}

