/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.event.IncrementalSynchronisationNotAvailableException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.plugin.rest.entity.EventEntityList;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import java.net.URI;

public class EventsController
extends AbstractResourceController {
    public EventsController(ApplicationService applicationService, ApplicationManager applicationManager) {
        super(applicationService, applicationManager);
    }

    public EventEntityList getCurrentEventToken(String applicationName) {
        Application application = this.getApplication(applicationName);
        try {
            return EventEntityList.fromToken(this.applicationService.getCurrentEventToken(application));
        }
        catch (IncrementalSynchronisationNotAvailableException e) {
            return EventEntityList.synchronisationNotAvailable();
        }
    }

    public EventEntityList getEventsSince(String applicationName, String eventToken, URI baseURI) throws EventTokenExpiredException, OperationFailedException {
        Application application = this.getApplication(applicationName);
        Events events = this.applicationService.getNewEvents(application, eventToken);
        return EntityTranslator.toEventEntities(events, baseURI);
    }
}

