/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.util;

import com.atlassian.crowd.plugin.adminchrome.components.ComponentService;
import com.atlassian.crowd.plugin.adminchrome.components.entity.ComponentEntity;
import com.atlassian.crowd.plugin.adminchrome.components.entity.ResourceEntity;
import com.atlassian.crowd.plugin.adminchrome.data.ComponentRetrievalException;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationTagBuilder {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationTagBuilder.class);
    private static final String VERSION_VARIABLE = "\\{version\\}";
    private final ComponentService componentService;

    public ConfigurationTagBuilder(ComponentService componentService) {
        this.componentService = componentService;
    }

    public String get() {
        try {
            Iterable visibleComponentsString = Iterables.transform(this.componentService.getVisibleComponents(), (Function)new Function<ComponentEntity, String>(){

                public String apply(ComponentEntity component) {
                    ResourceEntity resourceEntity = component.getResources();
                    String version = component.getVersion();
                    Iterable staticResources = Iterables.transform(resourceEntity.getJs(), (Function)ConfigurationTagBuilder.this.jsTagTransformer(version));
                    staticResources = Iterables.concat((Iterable)staticResources, (Iterable)Iterables.transform(resourceEntity.getCss(), (Function)ConfigurationTagBuilder.this.cssTagTransformer(version)));
                    return StringUtils.join(staticResources, "\n");
                }
            });
            return StringUtils.join(visibleComponentsString, "\n\n");
        }
        catch (ComponentRetrievalException e) {
            log.warn("A problem occurred while retrieving the visible components.", (Throwable)e);
            return "";
        }
    }

    private Function<String, String> jsTagTransformer(final String version) {
        return new Function<String, String>(){

            public String apply(String resourcePath) {
                String type = resourcePath.endsWith(".jsx") ? "text/jsx" : "text/javascript";
                return "<script type='" + type + "' src='" + resourcePath.replaceAll(ConfigurationTagBuilder.VERSION_VARIABLE, version) + "'></script>";
            }
        };
    }

    private Function<String, String> cssTagTransformer(final String version) {
        return new Function<String, String>(){

            public String apply(String resourcePath) {
                return "<link rel='stylesheet' type='text/css' href='" + resourcePath.replaceAll(ConfigurationTagBuilder.VERSION_VARIABLE, version) + "'/>";
            }
        };
    }
}

