/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.components.impl;

import com.atlassian.crowd.plugin.adminchrome.components.ComponentManager;
import com.atlassian.crowd.plugin.adminchrome.components.ComponentService;
import com.atlassian.crowd.plugin.adminchrome.components.entity.ComponentEntity;
import com.atlassian.crowd.plugin.adminchrome.data.ComponentRetrievalException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultComponentService
implements ComponentService {
    private static final Predicate<ComponentEntity> VISIBILITY_PREDICATE = new Predicate<ComponentEntity>(){

        public boolean apply(ComponentEntity component) {
            return component.isVisible();
        }
    };
    private static final Function<ComponentEntity, String> COMPONENT_NAME_FUNCTION = new Function<ComponentEntity, String>(){

        public String apply(ComponentEntity component) {
            return component.getName();
        }
    };
    private final ComponentManager componentManager;

    public DefaultComponentService(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    @Override
    @Nonnull
    public Set<ComponentEntity> getVisibleComponents() throws ComponentRetrievalException {
        return ImmutableSet.copyOf(this.getVisibleComponentEntities());
    }

    @Override
    @Nonnull
    public Set<String> getVisibleComponentsNames() throws ComponentRetrievalException {
        Iterable componentNames = Iterables.transform(this.getVisibleComponentEntities(), COMPONENT_NAME_FUNCTION);
        return ImmutableSet.copyOf((Iterable)componentNames);
    }

    private Iterable<ComponentEntity> getVisibleComponentEntities() throws ComponentRetrievalException {
        return Iterables.filter(this.componentManager.getAllComponents(), VISIBILITY_PREDICATE);
    }
}

